/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.organization;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.ux.IconUtils;
import org.teamapps.application.server.ux.UiUtils;
import org.teamapps.application.server.ux.combo.ComboBoxUtils;
import org.teamapps.application.server.ux.localize.TranslatableField;
import org.teamapps.application.server.ux.localize.TranslatableTextUtils;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.GeoLocationType;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class OrganizationUnitTypePerspective
extends AbstractManagedApplicationPerspective {
    private final TwoWayBindableValue<OrganizationUnitType> selectedType = TwoWayBindableValue.create();

    public OrganizationUnitTypePerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        View masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.ELEMENTS_CASCADE, (String)this.getLocalized("organizationUnitType.organizationUnitTypes"), null));
        View detailView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.ELEMENTS_CASCADE, (String)this.getLocalized("organizationUnitType.organizationUnitType"), null));
        detailView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        EntityModelBuilder orgUnitModelBuilder = new EntityModelBuilder(OrganizationUnitType::filter, this.getApplicationInstanceData());
        orgUnitModelBuilder.attachViewCountHandler(masterView, () -> this.getLocalized("organizationUnitType.organizationUnitTypes"));
        orgUnitModelBuilder.attachSearchField(masterView);
        orgUnitModelBuilder.onSelectedRecordChanged.addListener(arg_0 -> this.selectedType.set(arg_0));
        Table table = orgUnitModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setRowHeight(28);
        table.setStripedRows(false);
        orgUnitModelBuilder.updateModels();
        TemplateField<OrganizationUnitType> unitTypeField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData()));
        TemplateField<TranslatableText> abbreviationField = TranslatableTextUtils.createTranslatableTemplateField(this.getApplicationInstanceData());
        TemplateField<OrganizationUnitType> defaultChildField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData()));
        TagComboBox<OrganizationUnitType> allowedChildTypesField = UiUtils.createTagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData()));
        table.addColumn(new TableColumn("name", this.getLocalized("organizationUnitType.organizationUnitType"), unitTypeField).setDefaultWidth(170));
        table.addColumn(new TableColumn("abbreviation", this.getLocalized("organizationUnitType.abbreviation"), abbreviationField).setDefaultWidth(80));
        table.addColumn(new TableColumn("defaultChildType", this.getLocalized("organizationUnitType.defaultChildType"), defaultChildField).setDefaultWidth(130));
        table.addColumn(new TableColumn("possibleChildrenTypes", this.getLocalized("organizationUnitType.allowedChildrenTypes"), allowedChildTypesField).setDefaultWidth(350));
        table.setPropertyExtractor((unitType, propertyName) -> switch (propertyName) {
            case "name" -> unitType;
            case "abbreviation" -> unitType.getAbbreviation();
            case "defaultChildType" -> unitType.getDefaultChildType();
            case "possibleChildrenTypes" -> unitType.getPossibleChildrenTypes();
            default -> null;
        });
        masterView.setComponent((Component)table);
        ToolbarButtonGroup buttonGroup = detailView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton addButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ADD, (String)this.getLocalized("org.teamapps.dictionary.add"), (String)this.getLocalized("org.teamapps.dictionary.addRecord")));
        buttonGroup = detailView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton saveButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.FLOPPY_DISK, (String)this.getLocalized("org.teamapps.dictionary.saveChanges")));
        TranslatableField translatableNameField = TranslatableTextUtils.createTranslatableField(this.getApplicationInstanceData());
        TranslatableField translatableAbbreviationField = TranslatableTextUtils.createTranslatableField(this.getApplicationInstanceData());
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, (boolean)true);
        iconComboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        CheckBox translateOrgUnitsCheckBox = new CheckBox(this.getLocalized("organizationUnitType.translateOrganizationUnits"));
        CheckBox allowAsUserContainerCheckBox = new CheckBox(this.getLocalized("organizationUnitType.allowAsUserContainer"));
        ComboBox<OrganizationUnitType> defaultChildTypeCombo = this.createOrgUnitTypeComboBox();
        TagComboBox<OrganizationUnitType> possibleChildrenTagCombo = OrganizationUtils.createOrganizationUnitTypeTagComboBox(50, this.getApplicationInstanceData());
        ComboBox<GeoLocationType> geoLocationComboBox = this.createGeoLocationComboBox();
        ResponsiveForm form = new ResponsiveForm(120, 120, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.typeTitle"), (AbstractField)translatableNameField);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.abbreviation"), (AbstractField)translatableAbbreviationField);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.icon"), (AbstractField)iconComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.translateUnits"), (AbstractField)translateOrgUnitsCheckBox);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.allowUsers"), (AbstractField)allowAsUserContainerCheckBox);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.defaultChildType"), defaultChildTypeCombo);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.allowedChildrenTypes"), possibleChildrenTagCombo);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnitType.geoLocationType"), geoLocationComboBox);
        detailView.setComponent((Component)form);
        addButton.onClick.addListener(() -> this.selectedType.set((Object)OrganizationUnitType.create()));
        saveButton.onClick.addListener(() -> {
            OrganizationUnitType type = (OrganizationUnitType)this.selectedType.get();
            if (type != null && translatableNameField.getValue() != null && geoLocationComboBox.getValue() != null) {
                type.setName(translatableNameField.getValue()).setAbbreviation(translatableAbbreviationField.getValue()).setIcon(IconUtils.encodeNoStyle((Icon)iconComboBox.getValue())).setTranslateOrganizationUnits((Boolean)translateOrgUnitsCheckBox.getValue()).setAllowUserContainer((Boolean)allowAsUserContainerCheckBox.getValue()).setDefaultChildType((OrganizationUnitType)defaultChildTypeCombo.getValue()).setPossibleChildrenTypes((List)possibleChildrenTagCombo.getValue()).setGeoLocationType((GeoLocationType)((Object)((Object)geoLocationComboBox.getValue()))).save();
                UiUtils.showSaveNotification(true, this.getApplicationInstanceData());
                orgUnitModelBuilder.updateModels();
            } else {
                UiUtils.showSaveNotification(false, this.getApplicationInstanceData());
            }
        });
        this.selectedType.onChanged().addListener(type -> {
            translatableNameField.setValue(type.getName());
            translatableAbbreviationField.setValue(type.getAbbreviation());
            iconComboBox.setValue(IconUtils.decodeIcon(type.getIcon()));
            translateOrgUnitsCheckBox.setValue((Object)type.getTranslateOrganizationUnits());
            allowAsUserContainerCheckBox.setValue((Object)type.getAllowUserContainer());
            defaultChildTypeCombo.setValue((Object)type.getDefaultChildType());
            possibleChildrenTagCombo.setValue(type.getPossibleChildrenTypes());
            geoLocationComboBox.setValue((Object)type.getGeoLocationType());
        });
        this.selectedType.set((Object)OrganizationUnitType.create());
    }

    private ComboBox<OrganizationUnitType> createOrgUnitTypeComboBox() {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setModel(query -> query == null || query.isBlank() ? OrganizationUnitType.getAll().stream().limit(50L).collect(Collectors.toList()) : OrganizationUnitType.filter().parseFullTextFilter(query, new String[0]).execute().stream().limit(50L).collect(Collectors.toList()));
        PropertyProvider<OrganizationUnitType> propertyProvider = PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData());
        comboBox.setPropertyProvider(propertyProvider);
        comboBox.setRecordToStringFunction(unitType -> (String)propertyProvider.getValues(unitType, Collections.emptyList()).get("caption"));
        return comboBox;
    }

    private ComboBox<GeoLocationType> createGeoLocationComboBox() {
        PropertyProvider propertyProvider = (type, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", type != GeoLocationType.NONE ? ApplicationIcons.MAP_LOCATION : ApplicationIcons.SIGN_FORBIDDEN);
            map.put("caption", this.getLocalized("organizationUnitType.geoLocationType." + type.name()));
            return map;
        };
        return ComboBoxUtils.createRecordComboBox(Arrays.asList(GeoLocationType.values()), propertyProvider, (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
    }
}

