/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.systemlog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.ux.ApplicationUiUtils;
import org.teamapps.application.server.ux.UiUtils;
import org.teamapps.application.server.ux.combo.ComboBoxUtils;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LogLevel;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.SystemLog;
import org.teamapps.model.controlcenter.User;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.MultiLineTextField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.timegraph.TimeGraph;

public class SystemLogPerspective
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData;
    private final UserSessionData userSessionData;
    private final TwoWayBindableValue<SystemLog> selectedLog = TwoWayBindableValue.create();

    public SystemLogPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        View masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.CONSOLE, (String)this.getLocalized("systemLog.systemLogs"), null));
        View timeLineView = this.getPerspective().addView(View.createView((String)"top", (Icon)ApplicationIcons.FORM, (String)this.getLocalized("org.teamapps.dictionary.timeline"), null));
        View detailView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.CONSOLE, (String)this.getLocalized("systemLog.logMessage"), null));
        masterView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        detailView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        ComboBox<LogLevel> logLeveComboBox = this.createLogLeveComboBox();
        ComboBox<Application> applicationComboBox = ApplicationUiUtils.createApplicationComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.userSessionData);
        ComboBox<User> userComboBox = this.createUserComboBox();
        ComboBox<String> exceptionClassComboBox = this.createExceptionClassComboBox();
        logLeveComboBox.setShowClearButton(true);
        applicationComboBox.setShowClearButton(true);
        userComboBox.setShowClearButton(true);
        exceptionClassComboBox.setShowClearButton(true);
        ResponsiveForm selectionForm = new ResponsiveForm(50, 75, 200);
        selectionForm.setMargin(Spacing.px((int)0));
        ResponsiveFormLayout formLayout = selectionForm.addResponsiveFormLayout(500);
        formLayout.addSection().setCollapsible(false).setPadding(new Spacing(0, 5)).setMargin(new Spacing(4, 2, 4, 2));
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.logLevel"), logLeveComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.user"), userComboBox, false);
        formLayout.addLabelAndField(null, this.getLocalized("applications.application"), applicationComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.exceptionClass"), exceptionClassComboBox, false);
        EntityModelBuilder logModelBuilder = new EntityModelBuilder(() -> this.isAppFilter() ? SystemLog.filter().application(NumericFilter.equalsFilter((Number)this.getMainApplication().getId())) : SystemLog.filter(), this.getApplicationInstanceData());
        logModelBuilder.attachSearchField(masterView);
        logModelBuilder.attachViewCountHandler(masterView, () -> this.getLocalized("systemLog.systemLogs"));
        logModelBuilder.onSelectedRecordChanged.addListener(arg_0 -> this.selectedLog.set(arg_0));
        TimeGraph timeGraph = logModelBuilder.createTimeGraph(SystemLog::getMetaCreationDateAsEpochMilli, "metaCreationDate");
        logModelBuilder.updateModels();
        Table table = logModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setStripedRows(false);
        table.setRowHeight(28);
        table.setCssStyle("background-color", "white");
        table.setCssStyle("border-top", "1px solid " + Color.MATERIAL_GREY_400.toHtmlColorString());
        TemplateField<ManagedApplication> managedApplicationField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPropertyProvider(this.userSessionData));
        TemplateField<ManagedApplicationPerspective> perspectiveField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPerspectivePropertyProvider(this.userSessionData));
        TemplateField<Application> applicationField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createApplicationPropertyProvider(this.userSessionData));
        TemplateField<SystemLog> messageField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.createSystemLogPropertyProvider());
        InstantDateTimeField timeField = new InstantDateTimeField();
        table.addColumn(new TableColumn("managedApplication", this.getLocalized("applicationProvisioning.provisionedApplication"), managedApplicationField));
        table.addColumn(new TableColumn("managedPerspective", this.getLocalized("applications.perspective"), perspectiveField));
        table.addColumn(new TableColumn("message", this.getLocalized("systemLog.logMessage"), messageField).setDefaultWidth(230));
        table.addColumn(new TableColumn("metaCreationDate", this.getLocalized("org.teamapps.dictionary.date"), (AbstractField)timeField));
        table.setPropertyExtractor((systemLog, propertyName) -> switch (propertyName) {
            case "managedApplication" -> systemLog.getManagedApplication();
            case "managedPerspective" -> systemLog.getManagedPerspective();
            case "application" -> systemLog.getApplication();
            case "message" -> systemLog;
            case "metaCreationDate" -> systemLog.getMetaCreationDate();
            default -> null;
        });
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.addComponent((Component)selectionForm);
        verticalLayout.addComponentFillRemaining((Component)table);
        VerticalLayout detailsVerticalLayout = new VerticalLayout();
        ResponsiveForm form = new ResponsiveForm(120, 120, 0);
        detailsVerticalLayout.addComponent((Component)form);
        formLayout = form.addResponsiveFormLayout(450);
        TemplateField<Application> applicationFormField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createApplicationPropertyProvider(this.userSessionData));
        TemplateField<ManagedApplication> managedApplicationFormField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPropertyProvider(this.userSessionData));
        TemplateField<ManagedApplicationPerspective> perspectiveFormField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPerspectivePropertyProvider(this.userSessionData));
        TemplateField<LogLevel> logLevelFormField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.createLogLevelPropertyProvider());
        TemplateField<User> userFormField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createUserPropertyProvider(this.userSessionData));
        DisplayField exceptionClassFormField = new DisplayField();
        DisplayField messageFormField = new DisplayField();
        MultiLineTextField detailsFormField = new MultiLineTextField();
        InstantDateTimeField timeFormField = new InstantDateTimeField();
        timeFormField.setEditingMode(FieldEditingMode.READONLY);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("applicationProvisioning.provisionedApplication"), managedApplicationFormField);
        formLayout.addLabelAndField(null, this.getLocalized("applications.application"), applicationFormField);
        formLayout.addLabelAndField(null, this.getLocalized("applications.perspective"), perspectiveFormField);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.logLevel"), logLevelFormField);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.exceptionClass"), (AbstractField)exceptionClassFormField);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.user"), userFormField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.date"), (AbstractField)timeFormField);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.logMessage"), (AbstractField)messageFormField);
        detailsVerticalLayout.addComponentFillRemaining((Component)detailsFormField);
        timeLineView.setComponent((Component)timeGraph);
        masterView.setComponent((Component)verticalLayout);
        detailView.setComponent((Component)detailsVerticalLayout);
        Runnable onFilterChange = () -> {
            Predicate<SystemLog> filter = this.createFilter((LogLevel)((Object)((Object)logLeveComboBox.getValue())), (Application)applicationComboBox.getValue(), (User)userComboBox.getValue(), (String)exceptionClassComboBox.getValue());
            logModelBuilder.setCustomFilter(filter);
        };
        logLeveComboBox.onValueChanged.addListener(value -> onFilterChange.run());
        applicationComboBox.onValueChanged.addListener(value -> onFilterChange.run());
        userComboBox.onValueChanged.addListener(value -> onFilterChange.run());
        exceptionClassComboBox.onValueChanged.addListener(value -> onFilterChange.run());
        this.selectedLog.onChanged().addListener(log -> {
            managedApplicationFormField.setValue((Object)log.getManagedApplication());
            applicationFormField.setValue((Object)log.getApplication());
            perspectiveFormField.setValue((Object)log.getManagedPerspective());
            logLevelFormField.setValue((Object)log.getLogLevel());
            userFormField.setValue(log.getMetaCreatedBy() > 0 ? User.getById(log.getMetaCreatedBy()) : null);
            exceptionClassFormField.setValue((Object)log.getExceptionClass());
            messageFormField.setValue((Object)log.getMessage());
            detailsFormField.setValue((Object)log.getDetails());
            timeFormField.setValue((Object)log.getMetaCreationDate());
        });
    }

    private Predicate<SystemLog> createFilter(LogLevel logLevel, Application application, User user, String exceptionClass) {
        if (logLevel == null && application == null && user == null && exceptionClass == null) {
            return null;
        }
        return systemLog -> {
            if (logLevel != null && !logLevel.equals((Object)systemLog.getLogLevel())) {
                return false;
            }
            if (application != null && !application.equals(systemLog.getApplication())) {
                return false;
            }
            if (user != null && systemLog.getMetaCreatedBy() != user.getId()) {
                return false;
            }
            return exceptionClass == null || exceptionClass.equals(systemLog.getExceptionClass());
        };
    }

    private ComboBox<LogLevel> createLogLeveComboBox() {
        ComboBox<LogLevel> comboBox = ComboBoxUtils.createRecordComboBox(Arrays.asList(LogLevel.values()), this.createLogLevelPropertyProvider(), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        return comboBox;
    }

    private ComboBox<User> createUserComboBox() {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setPropertyProvider(PropertyProviders.createUserPropertyProvider(this.userSessionData));
        comboBox.setRecordToStringFunction(user -> user.getFirstName() + " " + user.getLastName());
        comboBox.setModel(query -> query == null || query.isBlank() ? User.getAll().stream().limit(50L).collect(Collectors.toList()) : User.filter().parseFullTextFilter(query, new String[0]).execute().stream().limit(50L).collect(Collectors.toList()));
        return comboBox;
    }

    private ComboBox<String> createExceptionClassComboBox() {
        HashSet exceptionClasses = new HashSet();
        SystemLog.getAll().forEach(log -> {
            if (log.getExceptionClass() != null) {
                exceptionClasses.add(log.getExceptionClass());
            }
        });
        return ComboBoxUtils.createRecordComboBox(new ArrayList(exceptionClasses), PropertyProviders.createStringPropertyProvider(ApplicationIcons.BUG), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
    }

    private PropertyProvider<LogLevel> createLogLevelPropertyProvider() {
        return (logLevel, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", this.getLoglevelIcon((LogLevel)((Object)logLevel)));
            map.put("caption", logLevel.name());
            return map;
        };
    }

    private PropertyProvider<SystemLog> createSystemLogPropertyProvider() {
        return (log, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", this.getLoglevelIcon(log.getLogLevel()));
            map.put("caption", log.getMessage());
            return map;
        };
    }

    private Icon getLoglevelIcon(LogLevel level) {
        return switch (level) {
            case LogLevel.INFO -> ApplicationIcons.INFORMATION;
            case LogLevel.WARNING -> ApplicationIcons.SIGN_WARNING;
            case LogLevel.ERROR -> ApplicationIcons.DELETE;
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

