/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap.installer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationBuilder;
import org.teamapps.application.api.localization.LocalizationData;
import org.teamapps.application.api.localization.LocalizationEntry;
import org.teamapps.application.api.localization.LocalizationEntrySet;
import org.teamapps.application.server.system.bootstrap.ApplicationInfo;
import org.teamapps.application.server.system.bootstrap.ApplicationInfoDataElement;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationInstallationPhase;
import org.teamapps.application.server.system.config.LocalizationConfig;
import org.teamapps.application.server.system.localization.ApplicationScopeLocalizationProvider;
import org.teamapps.application.server.system.localization.LocalizationUtil;
import org.teamapps.application.server.system.utils.KeyCompare;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationKeyType;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.universaldb.index.numeric.NumericFilter;

public class LocalizationDataInstallationPhase
implements ApplicationInstallationPhase {
    private final LocalizationConfig localizationConfig;

    public LocalizationDataInstallationPhase(LocalizationConfig localizationConfig) {
        this.localizationConfig = localizationConfig;
    }

    @Override
    public void checkApplication(ApplicationInfo applicationInfo) {
        try {
            if (!applicationInfo.getErrors().isEmpty()) {
                return;
            }
            ApplicationBuilder applicationBuilder = applicationInfo.getApplicationBuilder();
            LocalizationData localizationData = applicationBuilder.getLocalizationData();
            if (localizationData == null) {
                applicationInfo.addError("Missing localization data");
                return;
            }
            List localizationEntrySets = localizationData.getLocalizationEntrySets();
            if (!localizationData.containsAnyLanguage(this.localizationConfig.getAllowedSourceLanguages())) {
                applicationInfo.addError("Error: no supported language!:" + localizationEntrySets.stream().map(LocalizationEntrySet::getLanguage).collect(Collectors.joining(", ")));
                return;
            }
            ApplicationInfoDataElement dataInfo = new ApplicationInfoDataElement();
            dataInfo.setData(String.join((CharSequence)"\n", LocalizationDataInstallationPhase.getAllEntries(localizationEntrySets)));
            Application application = applicationInfo.getApplication();
            Map localizationMapByKey = localizationData.createLocalizationMapByKey();
            List localizationKeys = application == null ? Collections.emptyList() : LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)application.getId())).execute();
            KeyCompare<String, LocalizationKey> keyCompare = new KeyCompare<String, LocalizationKey>(localizationMapByKey.keySet(), localizationKeys, s -> s, LocalizationKey::getKey);
            List<String> newKeys = keyCompare.getNotInB();
            for (String key2 : newKeys) {
                Map translations = (Map)localizationMapByKey.get(key2);
                for (Map.Entry entry : translations.entrySet()) {
                    String language2 = (String)entry.getKey();
                    String original = (String)entry.getValue();
                    dataInfo.added(key2 + " -> " + language2 + ":" + original);
                }
            }
            List<LocalizationKey> removedKeys = keyCompare.getNotInA();
            removedKeys.stream().flatMap(key -> key.getLocalizationValues().stream()).forEach(value -> dataInfo.removed(value.getLocalizationKey().getKey() + " -> " + value.getLanguage() + ":" + value.getOriginal()));
            List<String> existingKeys = keyCompare.getInB();
            for (String key3 : existingKeys) {
                Map translations = (Map)localizationMapByKey.get(key3);
                LocalizationKey localizationKey = keyCompare.getB(key3);
                KeyCompare<String, LocalizationValue> languageCompare = new KeyCompare<String, LocalizationValue>(translations.keySet(), localizationKey.getLocalizationValues(), s -> s, LocalizationValue::getLanguage);
                if (!languageCompare.isDifferent()) continue;
                List<String> newLanguages = languageCompare.getNotInB();
                newLanguages.forEach(language -> dataInfo.added(key3 + " -> " + language + ":" + (String)translations.get(language)));
                List<LocalizationValue> removedLanguages = languageCompare.getNotInA();
                removedLanguages.forEach(value -> dataInfo.removed(key3 + " -> " + value.getLanguage() + ":" + value.getOriginal()));
            }
            applicationInfo.setLocalizationData(dataInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            applicationInfo.addError("Error checking localization data:" + e.getMessage());
        }
    }

    @Override
    public void installApplication(ApplicationInfo applicationInfo) {
        LocalizationData localizationData = applicationInfo.getApplicationBuilder().getLocalizationData();
        Application application = applicationInfo.getApplication();
        LocalizationKeyType localizationKeyType = LocalizationKeyType.APPLICATION_RESOURCE_KEY;
        LocalizationUtil.synchronizeLocalizationData(localizationData, application, localizationKeyType, this.localizationConfig.getRequiredLanguages());
    }

    @Override
    public void loadApplication(ApplicationInfo applicationInfo) {
        applicationInfo.getLoadedApplication().setApplicationLocalizationProvider(new ApplicationScopeLocalizationProvider(applicationInfo.getApplication()));
    }

    private static List<String> getAllEntries(List<LocalizationEntrySet> localizationEntrySets) {
        ArrayList<String> rows = new ArrayList<String>();
        for (LocalizationEntrySet localizationEntrySet : localizationEntrySets) {
            String language = localizationEntrySet.getLanguage();
            for (LocalizationEntry entry : localizationEntrySet.getEntries()) {
                rows.add(language + " -> " + entry.getKey() + ":" + entry.getValue());
            }
        }
        return rows;
    }
}

