/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.localization;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.server.system.localization.ApplicationScopeLocalizationProvider;
import org.teamapps.application.server.system.localization.DictionaryLocalizationProvider;
import org.teamapps.application.server.system.localization.LocalizationProvider;
import org.teamapps.application.server.system.localization.SystemLocalizationProvider;
import org.teamapps.universaldb.index.translation.TranslatableText;

public class UserLocalizationProvider
implements ApplicationLocalizationProvider,
LocalizationProvider {
    private final List<String> rankedLanguages;
    private final DictionaryLocalizationProvider dictionary;
    private final SystemLocalizationProvider systemDictionary;
    private final ApplicationScopeLocalizationProvider applicationScopeLocalizationProvider;

    public UserLocalizationProvider(List<String> rankedLanguages, DictionaryLocalizationProvider dictionary, SystemLocalizationProvider systemDictionary) {
        this(rankedLanguages, dictionary, systemDictionary, null);
    }

    public UserLocalizationProvider(List<String> rankedLanguages, DictionaryLocalizationProvider dictionary, SystemLocalizationProvider systemDictionary, ApplicationScopeLocalizationProvider applicationScopeLocalizationProvider) {
        this.rankedLanguages = new ArrayList<String>(rankedLanguages);
        this.dictionary = dictionary;
        this.systemDictionary = systemDictionary;
        this.applicationScopeLocalizationProvider = applicationScopeLocalizationProvider;
        if (!this.rankedLanguages.contains("en")) {
            this.rankedLanguages.add("en");
        }
    }

    @Override
    public String getLocalizationValue(String key, List<String> languagePriorityOrder) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        if (key.startsWith("org.teamapps.dictionary.")) {
            return this.dictionary.getLocalizationValue(key, languagePriorityOrder);
        }
        if (key.startsWith("org.teamapps.systemKey.")) {
            return this.systemDictionary.getLocalizationValue(key, languagePriorityOrder);
        }
        if (this.applicationScopeLocalizationProvider != null) {
            return this.applicationScopeLocalizationProvider.getLocalizationValue(key, languagePriorityOrder);
        }
        return null;
    }

    public String getLocalized(String key, Object ... parameters) {
        String localizationValue = this.getLocalizationValue(key, this.rankedLanguages);
        if (parameters != null && parameters.length > 0) {
            try {
                return MessageFormat.format(localizationValue, parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
                return localizationValue;
            }
        }
        return localizationValue;
    }

    public String getLocalized(TranslatableText translatableText) {
        if (translatableText == null) {
            return null;
        }
        Map translationMap = translatableText.getTranslationMap();
        for (String language : this.rankedLanguages) {
            String value = (String)translationMap.get(language);
            if (value == null) continue;
            return value;
        }
        return translatableText.getText();
    }
}

