/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.privilege;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationBuilder;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeObject;

public class ApplicationScopePrivilegeProvider {
    private final ApplicationBuilder applicationBuilder;
    private List<PrivilegeGroup> privilegeGroups;
    private List<ApplicationRole> applicationRoles;
    private Map<String, ApplicationRole> applicationRoleByName;
    private Map<String, PrivilegeGroup> privilegeGroupByName;
    private Map<String, Privilege> privilegeByName;

    public ApplicationScopePrivilegeProvider(ApplicationBuilder applicationBuilder) {
        this.applicationBuilder = applicationBuilder;
        this.loadPrivileges();
    }

    private void loadPrivileges() {
        this.privilegeGroups = this.applicationBuilder.getPrivilegeGroups();
        if (this.privilegeGroups == null) {
            return;
        }
        this.privilegeGroupByName = new HashMap<String, PrivilegeGroup>();
        this.privilegeByName = new HashMap<String, Privilege>();
        this.privilegeGroups.forEach(privilegeGroup -> {
            this.privilegeGroupByName.put(privilegeGroup.getName(), (PrivilegeGroup)privilegeGroup);
            if (privilegeGroup.getPrivileges() != null) {
                privilegeGroup.getPrivileges().forEach(privilege -> this.privilegeByName.put(privilege.getName(), (Privilege)privilege));
            }
        });
        this.applicationRoles = this.applicationBuilder.getApplicationRoles() != null ? this.applicationBuilder.getApplicationRoles() : Collections.emptyList();
        this.applicationRoleByName = this.applicationRoles.stream().collect(Collectors.toMap(ApplicationRole::getName, role -> role));
    }

    public PrivilegeGroup getPrivilegeGroup(String name) {
        return this.privilegeGroupByName.get(name);
    }

    public Privilege getPrivilege(String name) {
        return this.privilegeByName.get(name);
    }

    public List<Privilege> getPrivilegesByNameList(List<String> privilegeNames) {
        if (privilegeNames == null || privilegeNames.isEmpty()) {
            return null;
        }
        ArrayList<Privilege> privileges = new ArrayList<Privilege>();
        for (String privilegeName : privilegeNames) {
            Privilege privilege = this.getPrivilege(privilegeName);
            if (privilege == null) continue;
            privileges.add(privilege);
        }
        return privileges;
    }

    public List<PrivilegeObject> getPrivilegeObjects(PrivilegeGroup privilegeGroup, List<Integer> privilegeObjectIds, boolean withChildren) {
        if (privilegeObjectIds == null || privilegeObjectIds.isEmpty() || privilegeGroup.getPrivilegeObjectsSupplier() == null) {
            return null;
        }
        ArrayList<PrivilegeObject> result = new ArrayList<PrivilegeObject>();
        List privilegeObjects = (List)privilegeGroup.getPrivilegeObjectsSupplier().get();
        if (privilegeObjects != null) {
            Map<Integer, PrivilegeObject> privilegeObjectById = privilegeObjects.stream().collect(Collectors.toMap(PrivilegeObject::getId, privilegeObject -> privilegeObject));
            privilegeObjectIds.forEach(id -> {
                PrivilegeObject privilegeObject = (PrivilegeObject)privilegeObjectById.get(id);
                if (privilegeObject != null) {
                    result.add(privilegeObject);
                    if (withChildren) {
                        HashSet<PrivilegeObject> resultSet = new HashSet<PrivilegeObject>();
                        this.getAllChildren(privilegeObject, resultSet);
                        result.addAll(resultSet);
                    }
                }
            });
        }
        return result;
    }

    private void getAllChildren(PrivilegeObject privilegeObject, Set<PrivilegeObject> resultSet) {
        if (!resultSet.contains(privilegeObject) && privilegeObject.getChildren() != null) {
            for (PrivilegeObject child : privilegeObject.getChildren()) {
                resultSet.add(child);
                this.getAllChildren(child, resultSet);
            }
        }
    }

    public List<ApplicationRole> getApplicationRoles() {
        return this.applicationRoles;
    }

    public ApplicationRole getApplicationRole(String name) {
        return this.applicationRoleByName.get(name);
    }
}

