/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.privilege;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.server.system.privilege.PrivilegeApplicationKey;
import org.teamapps.application.server.system.privilege.UserPrivileges;
import org.teamapps.model.controlcenter.OrganizationUnitView;

public class UserApplicationPrivilege
implements ApplicationPrivilegeProvider {
    private final UserPrivileges userPrivileges;
    private final PrivilegeApplicationKey privilegeApplicationKey;
    private Set<SimplePrivilege> simplePrivileges;
    private Map<SimpleOrganizationalPrivilege, Set<OrganizationUnitView>> simpleOrganizationalPrivilegeSetMap;
    private Map<SimpleCustomObjectPrivilege, Set<PrivilegeObject>> simpleCustomObjectPrivilegeSetMap;
    private Map<StandardPrivilegeGroup, Set<Privilege>> standardPrivilegeGroupSetMap;
    private Map<OrganizationalPrivilegeGroup, Map<Privilege, Set<OrganizationUnitView>>> organizationalPrivilegeGroupMap;
    private Map<CustomObjectPrivilegeGroup, Map<Privilege, Set<PrivilegeObject>>> customObjectPrivilegeGroupMap;

    public UserApplicationPrivilege(UserPrivileges userPrivileges, PrivilegeApplicationKey privilegeApplicationKey) {
        this.userPrivileges = userPrivileges;
        this.privilegeApplicationKey = privilegeApplicationKey;
        this.init();
    }

    private void init() {
        this.simplePrivileges = this.userPrivileges.getSimplePrivilegesMap().get(this.privilegeApplicationKey);
        this.simpleOrganizationalPrivilegeSetMap = this.userPrivileges.getSimpleOrganizationPrivilegeMap().get(this.privilegeApplicationKey);
        this.simpleCustomObjectPrivilegeSetMap = this.userPrivileges.getSimpleCustomObjectPrivilegeMap().get(this.privilegeApplicationKey);
        this.standardPrivilegeGroupSetMap = this.userPrivileges.getStandardPrivilegeMap().get(this.privilegeApplicationKey);
        this.organizationalPrivilegeGroupMap = this.userPrivileges.getOrganizationPrivilegeGroupMap().get(this.privilegeApplicationKey);
        this.customObjectPrivilegeGroupMap = this.userPrivileges.getCustomObjectPrivilegeGroupMap().get(this.privilegeApplicationKey);
    }

    public boolean isAllowed(SimplePrivilege simplePrivilege) {
        if (this.simplePrivileges == null) {
            return false;
        }
        return this.simplePrivileges.contains(simplePrivilege);
    }

    public boolean isAllowed(SimpleOrganizationalPrivilege simpleOrganizationalPrivilege, OrganizationUnitView organizationUnitView) {
        if (this.simpleOrganizationalPrivilegeSetMap == null || !this.simpleOrganizationalPrivilegeSetMap.containsKey(simpleOrganizationalPrivilege)) {
            return false;
        }
        return this.simpleOrganizationalPrivilegeSetMap.get(simpleOrganizationalPrivilege).contains(organizationUnitView);
    }

    public boolean isAllowed(SimpleCustomObjectPrivilege simpleCustomObjectPrivilege, PrivilegeObject privilegeObject) {
        if (this.simpleCustomObjectPrivilegeSetMap == null || !this.simpleCustomObjectPrivilegeSetMap.containsKey(simpleCustomObjectPrivilege)) {
            return false;
        }
        return this.simpleCustomObjectPrivilegeSetMap.get(simpleCustomObjectPrivilege).contains(privilegeObject);
    }

    public boolean isAllowed(StandardPrivilegeGroup standardPrivilegeGroup, Privilege privilege) {
        if (this.standardPrivilegeGroupSetMap == null || !this.standardPrivilegeGroupSetMap.containsKey(standardPrivilegeGroup)) {
            return false;
        }
        return this.standardPrivilegeGroupSetMap.get(standardPrivilegeGroup).contains(privilege);
    }

    public boolean isAllowed(OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Privilege privilege, OrganizationUnitView organizationUnitView) {
        if (this.organizationalPrivilegeGroupMap == null || !this.organizationalPrivilegeGroupMap.containsKey(organizationalPrivilegeGroup)) {
            return false;
        }
        Set<OrganizationUnitView> organizationUnitViews = this.organizationalPrivilegeGroupMap.get(organizationalPrivilegeGroup).get(privilege);
        return organizationUnitViews != null && organizationUnitViews.contains(organizationUnitView);
    }

    public boolean isAllowed(CustomObjectPrivilegeGroup customObjectPrivilegeGroup, Privilege privilege, PrivilegeObject privilegeObject) {
        if (this.customObjectPrivilegeGroupMap == null || !this.customObjectPrivilegeGroupMap.containsKey(customObjectPrivilegeGroup)) {
            return false;
        }
        Set<PrivilegeObject> privilegeObjects = this.customObjectPrivilegeGroupMap.get(customObjectPrivilegeGroup).get(privilege);
        return privilegeObjects != null && privilegeObjects.contains(privilegeObject);
    }

    public List<OrganizationUnitView> getAllowedUnits(SimpleOrganizationalPrivilege simpleOrganizationalPrivilege) {
        if (this.simpleOrganizationalPrivilegeSetMap == null || !this.simpleOrganizationalPrivilegeSetMap.containsKey(simpleOrganizationalPrivilege)) {
            return Collections.emptyList();
        }
        return new ArrayList<OrganizationUnitView>((Collection)this.simpleOrganizationalPrivilegeSetMap.get(simpleOrganizationalPrivilege));
    }

    public List<OrganizationUnitView> getAllowedUnits(OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Privilege privilege) {
        if (this.organizationalPrivilegeGroupMap == null || !this.organizationalPrivilegeGroupMap.containsKey(organizationalPrivilegeGroup)) {
            return Collections.emptyList();
        }
        Set<OrganizationUnitView> organizationUnitViews = this.organizationalPrivilegeGroupMap.get(organizationalPrivilegeGroup).get(privilege);
        return new ArrayList<OrganizationUnitView>(organizationUnitViews);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege simpleCustomObjectPrivilege) {
        if (this.simpleCustomObjectPrivilegeSetMap == null || !this.simpleCustomObjectPrivilegeSetMap.containsKey(simpleCustomObjectPrivilege)) {
            return Collections.emptyList();
        }
        return new ArrayList<PrivilegeObject>((Collection)this.simpleCustomObjectPrivilegeSetMap.get(simpleCustomObjectPrivilege));
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup customObjectPrivilegeGroup, Privilege privilege) {
        if (this.customObjectPrivilegeGroupMap == null || !this.customObjectPrivilegeGroupMap.containsKey(customObjectPrivilegeGroup)) {
            return Collections.emptyList();
        }
        Set<PrivilegeObject> privilegeObjects = this.customObjectPrivilegeGroupMap.get(customObjectPrivilegeGroup).get(privilege);
        return new ArrayList<PrivilegeObject>(privilegeObjects);
    }
}

