/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.template;

import java.util.HashMap;
import java.util.function.Function;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.ux.IconUtils;
import org.teamapps.application.server.ux.localize.TranslatableTextUtils;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPerspective;
import org.teamapps.model.controlcenter.ApplicationPrivilege;
import org.teamapps.model.controlcenter.ApplicationPrivilegeGroup;
import org.teamapps.model.controlcenter.ApplicationVersion;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationGroup;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.model.controlcenter.Role;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserRoleAssignment;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.session.SessionContext;

public class PropertyProviders {
    public static PropertyProvider<Application> createApplicationPropertyProvider(UserSessionData userSessionData) {
        return (application, propertyNames) -> {
            ApplicationLocalizationProvider localizationProvider = userSessionData.getApplicationLocalizationProvider((Application)application);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", userSessionData.decodeIcon(application.getIcon()));
            map.put("caption", localizationProvider.getLocalized(application.getTitleKey(), new Object[0]));
            map.put("description", localizationProvider.getLocalized(application.getDescriptionKey(), new Object[0]));
            return map;
        };
    }

    public static PropertyProvider<ApplicationPerspective> createApplicationPerspectivePropertyProvider(UserSessionData userSessionData) {
        return (applicationPerspective, propertyNames) -> {
            ApplicationLocalizationProvider localizationProvider = userSessionData.getApplicationLocalizationProvider(applicationPerspective.getApplication());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", userSessionData.decodeIcon(applicationPerspective.getIcon()));
            map.put("caption", localizationProvider.getLocalized(applicationPerspective.getTitleKey(), new Object[0]));
            map.put("description", localizationProvider.getLocalized(applicationPerspective.getDescriptionKey(), new Object[0]));
            return map;
        };
    }

    public static PropertyProvider<ApplicationPrivilege> createApplicationPrivilegePropertyProvider(UserSessionData userSessionData) {
        return (applicationPrivilege, propertyNames) -> {
            ApplicationLocalizationProvider localizationProvider = userSessionData.getApplicationLocalizationProvider(applicationPrivilege.getPrivilegeGroup().getApplication());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", userSessionData.decodeIcon(applicationPrivilege.getIcon()));
            map.put("caption", localizationProvider.getLocalized(applicationPrivilege.getTitleKey(), new Object[0]));
            return map;
        };
    }

    public static PropertyProvider<ApplicationPrivilegeGroup> createApplicationPrivilegeGroupPropertyProvider(UserSessionData userSessionData) {
        return (applicationPrivilegeGroup, propertyNames) -> {
            ApplicationLocalizationProvider localizationProvider = userSessionData.getApplicationLocalizationProvider(applicationPrivilegeGroup.getApplication());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", userSessionData.decodeIcon(applicationPrivilegeGroup.getIcon()));
            map.put("caption", localizationProvider.getLocalized(applicationPrivilegeGroup.getTitleKey(), new Object[0]));
            map.put("description", localizationProvider.getLocalized(applicationPrivilegeGroup.getDescriptionKey(), new Object[0]));
            return map;
        };
    }

    public static PropertyProvider<PrivilegeObject> createPrivilegeObjectPropertyProvider() {
        return (privilegeObject, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", privilegeObject.getIcon());
            map.put("caption", privilegeObject.getTitleKey());
            map.put("description", privilegeObject.getDescriptionKey());
            return map;
        };
    }

    public static PropertyProvider<ApplicationVersion> createSimpleApplicationVersionPropertyProvider() {
        return (version, propertyNames) -> {
            SessionContext context = SessionContext.current();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", context.getIconProvider().decodeIcon(version.getApplication().getIcon()));
            map.put("caption", version.getVersion());
            map.put("description", version.getReleaseNotes());
            return map;
        };
    }

    public static PropertyProvider<ApplicationVersion> createApplicationVersionPropertyProvider(UserSessionData userSessionData) {
        return (version, propertyNames) -> {
            ApplicationLocalizationProvider localizationProvider = userSessionData.getApplicationLocalizationProvider(version.getApplication());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", userSessionData.decodeIcon(version.getApplication().getIcon()));
            map.put("caption", localizationProvider.getLocalized(version.getApplication().getTitleKey(), new Object[0]) + ": " + version.getVersion());
            map.put("description", version.getReleaseNotes());
            return map;
        };
    }

    public static PropertyProvider<ManagedApplication> createManagedApplicationPropertyProvider(UserSessionData userSessionData) {
        return (managedApplication, propertyNames) -> {
            ApplicationLocalizationProvider localizationProvider = userSessionData.getApplicationLocalizationProvider(managedApplication.getMainApplication());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", managedApplication.getIcon() != null ? userSessionData.decodeIcon(managedApplication.getIcon()) : userSessionData.decodeIcon(managedApplication.getMainApplication().getIcon()));
            map.put("caption", managedApplication.getTitleKey() != null ? localizationProvider.getLocalized(managedApplication.getTitleKey(), new Object[0]) : localizationProvider.getLocalized(managedApplication.getMainApplication().getTitleKey(), new Object[0]));
            map.put("description", managedApplication.getDescriptionKey() != null ? localizationProvider.getLocalized(managedApplication.getDescriptionKey(), new Object[0]) : localizationProvider.getLocalized(managedApplication.getMainApplication().getDescriptionKey(), new Object[0]));
            map.put("badge", managedApplication.getHidden() ? localizationProvider.getLocalized("org.teamapps.dictionary.hidden", new Object[0]) : null);
            return map;
        };
    }

    public static PropertyProvider<ManagedApplicationPerspective> createManagedApplicationPerspectivePropertyProvider(UserSessionData userSessionData) {
        return (managedApplicationPerspective, propertyNames) -> {
            ApplicationLocalizationProvider localizationProvider = userSessionData.getApplicationLocalizationProvider(managedApplicationPerspective.getApplicationPerspective().getApplication());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", managedApplicationPerspective.getIconOverride() != null ? userSessionData.decodeIcon(managedApplicationPerspective.getIconOverride()) : userSessionData.decodeIcon(managedApplicationPerspective.getApplicationPerspective().getIcon()));
            map.put("caption", managedApplicationPerspective.getTitleKeyOverride() != null ? localizationProvider.getLocalized(managedApplicationPerspective.getTitleKeyOverride(), new Object[0]) : localizationProvider.getLocalized(managedApplicationPerspective.getApplicationPerspective().getTitleKey(), new Object[0]));
            map.put("description", managedApplicationPerspective.getDescriptionKeyOverride() != null ? localizationProvider.getLocalized(managedApplicationPerspective.getDescriptionKeyOverride(), new Object[0]) : localizationProvider.getLocalized(managedApplicationPerspective.getApplicationPerspective().getDescriptionKey(), new Object[0]));
            return map;
        };
    }

    public static PropertyProvider<ManagedApplicationGroup> createManagedApplicationGroupPropertyProvider(UserSessionData userSessionData) {
        return (managedApplicationGroup, propertyNames) -> {
            ApplicationLocalizationProvider localizationProvider = userSessionData.getDictionary();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", userSessionData.decodeIcon(managedApplicationGroup.getIcon()));
            map.put("caption", localizationProvider.getLocalized(managedApplicationGroup.getTitleKey(), new Object[0]));
            return map;
        };
    }

    public static PropertyProvider<OrganizationField> createOrganizationFieldPropertyProvider(ApplicationInstanceData applicationInstanceData) {
        return (organizationFieldView, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", IconUtils.decodeIcon(organizationFieldView.getIcon()));
            map.put("caption", applicationInstanceData.getLocalized(organizationFieldView.getTitle()));
            return map;
        };
    }

    public static PropertyProvider<OrganizationUnitType> creatOrganizationUnitTypePropertyProvider(ApplicationInstanceData applicationInstanceData) {
        Function<TranslatableText, String> translatableTextExtractor = TranslatableTextUtils.createTranslatableTextExtractor(applicationInstanceData);
        return (unitType, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", IconUtils.decodeIcon(unitType.getIcon()));
            map.put("caption", translatableTextExtractor.apply(unitType.getName()));
            map.put("description", translatableTextExtractor.apply(unitType.getAbbreviation()));
            return map;
        };
    }

    public static PropertyProvider<OrganizationUnit> creatOrganizationUnitPropertyProvider(ApplicationInstanceData applicationInstanceData) {
        Function<TranslatableText, String> translatableTextExtractor = TranslatableTextUtils.createTranslatableTextExtractor(applicationInstanceData);
        return (unit, propertyNames) -> {
            Object prefix = "";
            String abbreviation = (String)translatableTextExtractor.apply(unit.getType().getAbbreviation());
            if (abbreviation != null) {
                prefix = abbreviation + "-";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", unit.getIcon() != null ? IconUtils.decodeIcon(unit.getIcon()) : IconUtils.decodeIcon(unit.getType().getIcon()));
            map.put("caption", (String)prefix + (String)translatableTextExtractor.apply(unit.getName()));
            map.put("description", translatableTextExtractor.apply(unit.getType().getName()));
            return map;
        };
    }

    public static PropertyProvider<Role> createRolePropertyProvider(ApplicationInstanceData applicationInstanceData) {
        return (role, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", IconUtils.decodeIcon(role.getIcon()));
            map.put("caption", applicationInstanceData.getLocalized(role.getTitle()));
            map.put("description", role.getOrganizationField() != null ? applicationInstanceData.getLocalized(role.getOrganizationField().getTitle()) : null);
            return map;
        };
    }

    public static PropertyProvider<User> createUserPropertyProvider(UserSessionData userSessionData) {
        Function<TranslatableText, String> translatableTextExtractor = TranslatableTextUtils.createTranslatableTextExtractor(userSessionData.getRankedLanguages());
        return (user, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String userProfilePictureLink = userSessionData.getRegistry().getBaseResourceLinkProvider().getUserProfilePictureLink((User)user);
            if (userProfilePictureLink != null) {
                map.put("image", userProfilePictureLink);
            } else {
                map.put("icon", ApplicationIcons.USER);
            }
            map.put("caption", user.getFirstName() + " " + user.getLastName());
            map.put("description", user.getContainer() != null ? (Object)translatableTextExtractor.apply(user.getContainer().getOrganizationUnit().getName()) : null);
            return map;
        };
    }

    public static PropertyProvider<UserRoleAssignment> createUserRoleAssignmentPropertyProvider(UserSessionData userSessionData) {
        Function<TranslatableText, String> translatableTextExtractor = TranslatableTextUtils.createTranslatableTextExtractor(userSessionData.getRankedLanguages());
        return (assignment, propertyNames) -> {
            Object prefix = "";
            String abbreviation = (String)translatableTextExtractor.apply(assignment.getOrganizationUnit().getType().getAbbreviation());
            if (abbreviation != null) {
                prefix = abbreviation + "-";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            String userProfilePictureLink = userSessionData.getRegistry().getBaseResourceLinkProvider().getUserProfilePictureLink(assignment.getUser());
            if (userProfilePictureLink != null) {
                map.put("image", userProfilePictureLink);
            } else {
                map.put("icon", IconUtils.decodeIcon(assignment.getRole().getIcon()));
            }
            map.put("caption", assignment.getUser().getFirstName() + " " + assignment.getUser().getLastName());
            map.put("description", (String)prefix + (String)translatableTextExtractor.apply(assignment.getOrganizationUnit().getName()));
            map.put("badge", translatableTextExtractor.apply(assignment.getRole().getTitle()));
            return map;
        };
    }

    public static PropertyProvider<String> createStringPropertyProvider(Icon icon) {
        return (s, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", icon);
            map.put("caption", s);
            return map;
        };
    }
}

