package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface ApplicationVersionQuery extends Query<ApplicationVersion> {

    static ApplicationVersionQuery create() {
        return new UdbApplicationVersionQuery();
    }

    ApplicationVersionQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ApplicationVersionQuery parseFullTextFilter(String query, String... fieldNames);

	ApplicationVersionQuery metaCreationDate(NumericFilter filter);

	ApplicationVersionQuery orMetaCreationDate(NumericFilter filter);

	ApplicationVersionQuery metaCreatedBy(NumericFilter filter);

	ApplicationVersionQuery orMetaCreatedBy(NumericFilter filter);

	ApplicationVersionQuery metaModificationDate(NumericFilter filter);

	ApplicationVersionQuery orMetaModificationDate(NumericFilter filter);

	ApplicationVersionQuery metaModifiedBy(NumericFilter filter);

	ApplicationVersionQuery orMetaModifiedBy(NumericFilter filter);

	ApplicationVersionQuery metaDeletionDate(NumericFilter filter);

	ApplicationVersionQuery orMetaDeletionDate(NumericFilter filter);

	ApplicationVersionQuery metaDeletedBy(NumericFilter filter);

	ApplicationVersionQuery orMetaDeletedBy(NumericFilter filter);

	ApplicationVersionQuery metaRestoreDate(NumericFilter filter);

	ApplicationVersionQuery orMetaRestoreDate(NumericFilter filter);

	ApplicationVersionQuery metaRestoredBy(NumericFilter filter);

	ApplicationVersionQuery orMetaRestoredBy(NumericFilter filter);

	ApplicationVersionQuery filterApplication(ApplicationQuery query);

	ApplicationVersionQuery application(NumericFilter filter);

	ApplicationVersionQuery orApplication(NumericFilter filter);

	ApplicationVersionQuery binary(FileFilter filter);

	ApplicationVersionQuery orBinary(FileFilter filter);

	ApplicationVersionQuery binaryHash(TextFilter filter);

	ApplicationVersionQuery orBinaryHash(TextFilter filter);

	ApplicationVersionQuery version(TextFilter filter);

	ApplicationVersionQuery orVersion(TextFilter filter);

	ApplicationVersionQuery releaseNotes(TextFilter filter);

	ApplicationVersionQuery orReleaseNotes(TextFilter filter);

	ApplicationVersionQuery filterDataModelData(ApplicationVersionDataQuery query);

	ApplicationVersionQuery dataModelData(NumericFilter filter);

	ApplicationVersionQuery orDataModelData(NumericFilter filter);

	ApplicationVersionQuery filterLocalizationData(ApplicationVersionDataQuery query);

	ApplicationVersionQuery localizationData(NumericFilter filter);

	ApplicationVersionQuery orLocalizationData(NumericFilter filter);

	ApplicationVersionQuery filterPrivilegeData(ApplicationVersionDataQuery query);

	ApplicationVersionQuery privilegeData(NumericFilter filter);

	ApplicationVersionQuery orPrivilegeData(NumericFilter filter);

	ApplicationVersionQuery filterPerspectiveData(ApplicationVersionDataQuery query);

	ApplicationVersionQuery perspectiveData(NumericFilter filter);

	ApplicationVersionQuery orPerspectiveData(NumericFilter filter);


    ApplicationVersionQuery andOr(ApplicationVersionQuery... queries);

    ApplicationVersionQuery customFilter(Function<ApplicationVersion, Boolean> customFilter);

    List<ApplicationVersion> execute();

    List<ApplicationVersion> executeOnDeletedRecords();

    ApplicationVersion executeExpectSingleton();

    BitSet executeToBitSet();

    List<ApplicationVersion> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<ApplicationVersion> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

