package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbAddressViewQuery extends AbstractUdbQuery<AddressView> implements AddressViewQuery {

    public UdbAddressViewQuery() {
        super(UdbAddressView.table, AddressView.getBuilder());
    }

	@Override
	public AddressViewQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbAddressView.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public AddressViewQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbAddressView.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public AddressViewQuery name(TextFilter filter) {
		and(UdbAddressView.name.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery orName(TextFilter filter) {
		or(UdbAddressView.name.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery organisation(TextFilter filter) {
		and(UdbAddressView.organisation.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery orOrganisation(TextFilter filter) {
		or(UdbAddressView.organisation.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery street(TextFilter filter) {
		and(UdbAddressView.street.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery orStreet(TextFilter filter) {
		or(UdbAddressView.street.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery city(TextFilter filter) {
		and(UdbAddressView.city.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery orCity(TextFilter filter) {
		or(UdbAddressView.city.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery dependentLocality(TextFilter filter) {
		and(UdbAddressView.dependentLocality.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery orDependentLocality(TextFilter filter) {
		or(UdbAddressView.dependentLocality.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery state(TextFilter filter) {
		and(UdbAddressView.state.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery orState(TextFilter filter) {
		or(UdbAddressView.state.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery postalCode(TextFilter filter) {
		and(UdbAddressView.postalCode.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery orPostalCode(TextFilter filter) {
		or(UdbAddressView.postalCode.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery country(TextFilter filter) {
		and(UdbAddressView.country.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery orCountry(TextFilter filter) {
		or(UdbAddressView.country.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery latitude(NumericFilter filter) {
		and(UdbAddressView.latitude.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery orLatitude(NumericFilter filter) {
		or(UdbAddressView.latitude.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery longitude(NumericFilter filter) {
		and(UdbAddressView.longitude.createFilter(filter));
		return this;
	}

	@Override
	public AddressViewQuery orLongitude(NumericFilter filter) {
		or(UdbAddressView.longitude.createFilter(filter));
		return this;
	}


	@Override
	public UdbAddressViewQuery andOr(AddressViewQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public AddressViewQuery customFilter(Function<AddressView, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(AddressView.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



