/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.organization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.users.UserUtils;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.Templates;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.localize.TranslatableTextUtils;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.UserRoleAssignment;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.charting.common.GraphNodeIcon;
import org.teamapps.ux.component.charting.common.GraphNodeImage;
import org.teamapps.ux.component.charting.tree.BaseTreeGraphNode;
import org.teamapps.ux.component.charting.tree.TreeGraph;
import org.teamapps.ux.component.charting.tree.TreeGraphNode;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class OrganizationChartPerspective
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
    private final UserSessionData userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
    private TreeGraph<OrgNode> treeGraph;
    private float zoomFactor = 1.0f;
    private List<TreeGraphNode<OrgNode>> treeNodes;

    public OrganizationChartPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        View masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.PIECES, (String)this.getLocalized("organizationField.organizationFields"), null));
        masterView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.75f));
        ToolbarButtonGroup buttonGroup = masterView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton standardViewButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ELEMENTS_HIERARCHY, (String)this.getLocalized("organizationChart.standardView"), (String)this.getLocalized("organizationChart.standardView.desc")));
        ToolbarButton compactViewButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ELEMENTS_TREE, (String)this.getLocalized("organizationChart.compactView"), (String)this.getLocalized("organizationChart.compactView.desc")));
        buttonGroup = masterView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton zoomInButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ZOOM_IN, (String)this.getLocalized("org.teamapps.dictionary.zoomIn"), (String)this.getLocalized("org.teamapps.dictionary.zoomIn")));
        ToolbarButton zoomOutButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ZOOM_OUT, (String)this.getLocalized("org.teamapps.dictionary.zoomOut"), (String)this.getLocalized("org.teamapps.dictionary.zoomOut")));
        standardViewButton.onClick.addListener(() -> this.treeGraph.setCompact(false));
        compactViewButton.onClick.addListener(() -> this.treeGraph.setCompact(true));
        zoomInButton.onClick.addListener(() -> {
            this.zoomFactor *= 1.5f;
            this.treeGraph.setZoomFactor(this.zoomFactor);
            this.treeGraph.setNodes(this.treeNodes);
        });
        zoomOutButton.onClick.addListener(() -> {
            this.zoomFactor /= 1.5f;
            this.treeGraph.setZoomFactor(this.zoomFactor);
            this.treeGraph.setNodes(this.treeNodes);
        });
        if (OrganizationField.getCount() == 0) {
            return;
        }
        OrganizationField organizationField = this.getOrganizationField() != null ? this.getOrganizationField() : OrganizationField.getAll().get(0);
        HashSet<OrganizationUnit> units = new HashSet<OrganizationUnit>(OrganizationUnit.getAll());
        Set<OrganizationUnit> allowedUnits = units.stream().flatMap(unit -> this.getRootChain((OrganizationUnit)unit).stream()).collect(Collectors.toSet());
        this.createUi(allowedUnits, organizationField, masterView);
    }

    private void createUi(Set<OrganizationUnit> allowedUnits, OrganizationField organizationField, View masterView) {
        this.treeGraph = new TreeGraph();
        Map<OrganizationUnit, List<UserRoleAssignment>> roleAssignmentsByOrganizationUnit = UserRoleAssignment.getAll().stream().filter(userRoleAssignment -> allowedUnits.contains(userRoleAssignment.getOrganizationUnit())).filter(userRoleAssignment -> organizationField.equals(userRoleAssignment.getRole().getOrganizationField())).collect(Collectors.groupingBy(UserRoleAssignment::getOrganizationUnit));
        this.treeNodes = new ArrayList<TreeGraphNode<OrgNode>>();
        HashMap<OrganizationUnit, TreeGraphNode<OrgNode>> nodeByOrgUnit = new HashMap<OrganizationUnit, TreeGraphNode<OrgNode>>();
        Iterator<OrganizationUnit> iterator = allowedUnits.iterator();
        while (iterator.hasNext()) {
            OrganizationUnit organizationUnit;
            List<UserRoleAssignment> userRoleAssignments = roleAssignmentsByOrganizationUnit.get(organizationUnit = iterator.next());
            TreeGraphNode<OrgNode> node2 = this.createNode(organizationUnit, userRoleAssignments != null ? userRoleAssignments : Collections.emptyList());
            this.treeNodes.add(node2);
            nodeByOrgUnit.put(organizationUnit, node2);
        }
        this.treeNodes.forEach(node -> {
            node.setParent((TreeGraphNode)nodeByOrgUnit.get(((OrgNode)node.getRecord()).getOrganizationUnit().getParent()));
            node.setParentExpandable(node.getParent() != null);
        });
        this.treeGraph.setPropertyProvider(this.createPropertyProvider());
        this.treeGraph.setHorizontalSiblingGap(40);
        this.treeGraph.setHorizontalNonSignlingGap(60);
        this.treeGraph.setVerticalLayerGap(75);
        this.treeGraph.setNodes(this.treeNodes);
        masterView.setComponent(this.treeGraph);
    }

    private TreeGraphNode<OrgNode> createNode(OrganizationUnit unit, List<UserRoleAssignment> userRoleAssignments) {
        TreeGraphNode node = new TreeGraphNode();
        UserRoleAssignment mainAssignment = userRoleAssignments.stream().sorted(this.getRoleAssignmentComparator()).findAny().orElse(null);
        node.setRecord((Object)new OrgNode(unit, mainAssignment));
        node.setTemplate((Template)Templates.ORGANIZATION_GRAPH_TEMPLATE);
        node.setWidth(240);
        node.setHeight(68);
        node.setBorderRadius(10.0f);
        node.setBorderWidth(1.0f);
        node.setConnectorLineColor((Color)Color.MATERIAL_BLUE_700);
        node.setBorderColor((Color)Color.MATERIAL_BLUE_700);
        node.setBackgroundColor((Color)Color.MATERIAL_BLUE_100);
        node.setExpanded(false);
        if (mainAssignment != null && UserUtils.getProfilePictureLink(mainAssignment.getUser(), this.userSessionData) != null) {
            String pictureLink = UserUtils.getProfilePictureLink(mainAssignment.getUser(), this.userSessionData);
            node.setImage(new GraphNodeImage(pictureLink, 70, 70).setBorderColor((Color)Color.MATERIAL_BLUE_700).setBorderWidth(1.0f).setCenterLeftDistance(0).setCenterTopDistance(34).setCornerShape(GraphNodeImage.CornerShape.CIRCLE));
        } else {
            node.setIcon(new GraphNodeIcon(IconUtils.decodeIcon((String)(unit.getIcon() != null ? unit.getIcon() : unit.getType().getIcon())), 54));
        }
        List sideNodes = userRoleAssignments.stream().filter(assignment -> assignment != mainAssignment).map(assignment -> this.createSideNode(unit, (UserRoleAssignment)assignment)).collect(Collectors.toList());
        node.setSideListNodes(sideNodes);
        return node;
    }

    private Comparator<UserRoleAssignment> getRoleAssignmentComparator() {
        return (o1, o2) -> this.getSortScore((UserRoleAssignment)o1) > this.getSortScore((UserRoleAssignment)o2) ? -1 : 0;
    }

    private int getSortScore(UserRoleAssignment assignment) {
        int score = assignment.getRole().getParent() != null ? 0 : 10;
        return score += assignment.getUser().getProfilePicture() != null ? 1 : 0;
    }

    private BaseTreeGraphNode<OrgNode> createSideNode(OrganizationUnit unit, UserRoleAssignment userRoleAssignment) {
        BaseTreeGraphNode node = new BaseTreeGraphNode();
        node.setTemplate((Template)Templates.ORGANIZATION_GRAPH_SMALL_TEMPLATE);
        node.setRecord((Object)new OrgNode(unit, userRoleAssignment));
        node.setWidth(200);
        node.setHeight(40);
        node.setBorderRadius(7.0f);
        node.setBorderWidth(1.0f);
        node.setBorderColor((Color)Color.MATERIAL_GREEN_900);
        node.setBackgroundColor((Color)Color.MATERIAL_GREEN_100);
        node.setConnectorLineColor((Color)Color.MATERIAL_BLUE_700);
        String pictureLink = UserUtils.getProfilePictureLink(userRoleAssignment.getUser(), this.userSessionData);
        if (pictureLink != null) {
            node.setImage(new GraphNodeImage(pictureLink, 55, 55).setBorderColor((Color)Color.MATERIAL_BLUE_700).setBorderWidth(1.0f).setCenterLeftDistance(0).setCenterTopDistance(20).setCornerShape(GraphNodeImage.CornerShape.CIRCLE));
        } else {
            node.setIcon(new GraphNodeIcon(IconUtils.decodeIcon((String)(unit.getIcon() != null ? unit.getIcon() : unit.getType().getIcon())), 32));
        }
        return node;
    }

    private List<OrganizationUnit> getRootChain(OrganizationUnit unit) {
        ArrayList<OrganizationUnit> chain = new ArrayList<OrganizationUnit>();
        while (unit != null) {
            chain.add(unit);
            unit = unit.getParent();
        }
        return chain;
    }

    private PropertyProvider<OrgNode> createPropertyProvider() {
        Function translatableTextExtractor = TranslatableTextUtils.createTranslatableTextExtractor(this.userSessionData.getRankedLanguages());
        return (orgNode, collection) -> {
            OrganizationUnit unit = orgNode.getOrganizationUnit();
            Object prefix = "";
            String abbreviation = (String)translatableTextExtractor.apply(unit.getType().getAbbreviation());
            if (abbreviation != null) {
                prefix = abbreviation + "-";
            }
            String unitName = (String)prefix + (String)translatableTextExtractor.apply(unit.getName());
            Object name = (String)translatableTextExtractor.apply(unit.getType().getName());
            String role = null;
            if (orgNode.getUserRoleAssignment() != null) {
                UserRoleAssignment assignment = orgNode.getUserRoleAssignment();
                name = assignment.getUser().getFirstName() + " " + assignment.getUser().getLastName();
                role = (String)translatableTextExtractor.apply(assignment.getRole().getTitle());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("caption", unitName);
            map.put("description", name);
            map.put("line3", role);
            return map;
        };
    }

    public static class OrgNode {
        private final OrganizationUnit organizationUnit;
        private final UserRoleAssignment userRoleAssignment;

        public OrgNode(OrganizationUnit organizationUnit, UserRoleAssignment userRoleAssignment) {
            this.organizationUnit = organizationUnit;
            this.userRoleAssignment = userRoleAssignment;
        }

        public OrganizationUnit getOrganizationUnit() {
            return this.organizationUnit;
        }

        public UserRoleAssignment getUserRoleAssignment() {
            return this.userRoleAssignment;
        }
    }
}

