/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.messaging.newsboard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.coobird.thumbnailator.Thumbnailator;
import org.teamapps.application.api.application.AbstractApplicationView;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.messaging.MessagingPrivileges;
import org.teamapps.application.server.messaging.newsboard.NewsBoardPerspective;
import org.teamapps.application.server.messaging.newsboard.NewsBoardUtils;
import org.teamapps.application.server.messaging.newsboard.TranslationSelectionDialogue;
import org.teamapps.application.server.messaging.newsboard.views.EditorView;
import org.teamapps.application.server.messaging.newsboard.views.ImageListView;
import org.teamapps.application.server.messaging.newsboard.views.LanguageSelectionView;
import org.teamapps.application.server.messaging.newsboard.views.MessageView;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.ui.dialogue.UploadDialogue;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icon.flags.FlagIcon;
import org.teamapps.icons.Icon;
import org.teamapps.icons.composite.CompositeIcon;
import org.teamapps.model.controlcenter.NewsBoardMessage;
import org.teamapps.model.controlcenter.NewsBoardMessageImage;
import org.teamapps.model.controlcenter.NewsBoardMessageTranslation;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.field.upload.simple.FileItem;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.window.Window;

public class MessageWindow
extends AbstractApplicationView {
    private final NewsBoardMessage message;
    private final SystemRegistry registry;
    private Window window;
    private ResponsiveApplication application;
    private boolean activeEditor;
    private NewsBoardMessageTranslation selectedTranslation;
    private final EditorView editorView;
    private final View centerView;
    private TwoWayBindableValue<String> selectedLanguage = TwoWayBindableValue.create();

    public MessageWindow(NewsBoardMessage message, NewsBoardPerspective newsBoardPerspective, ApplicationInstanceData applicationInstanceData, SystemRegistry registry) {
        super(applicationInstanceData);
        this.message = message;
        this.registry = registry;
        this.application = ResponsiveApplication.createApplication();
        Perspective perspective = this.application.addPerspective(Perspective.createPerspective());
        View languageView = perspective.addView(View.createView((String)"left", (Icon)ApplicationIcons.EARTH, (String)this.getLocalized("org.teamapps.dictionary.language", new Object[0]), null));
        languageView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.94f));
        languageView.setVisible(false);
        this.centerView = perspective.addView(View.createView((String)"center", (Icon)ApplicationIcons.MESSAGE, (String)this.getLocalized("newsBoard.message", new Object[0]), null));
        this.centerView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.7f));
        View imageView = perspective.addView(View.createView((String)"outer-right", (Icon)ApplicationIcons.PHOTO_LANDSCAPE, (String)this.getLocalized("newsBoard.images", new Object[0]), null));
        imageView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.94f));
        imageView.setSize(ViewSize.ofAbsoluteWidth((int)120));
        imageView.setSize(ViewSize.ofRelativeWidth((float)0.15f));
        imageView.setVisible(false);
        this.centerView.setSize(ViewSize.ofRelativeWidth((float)0.8f));
        ToolbarButtonGroup buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton saveButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.FLOPPY_DISK, (String)this.getLocalized("org.teamapps.dictionary.save", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.saveChanges", new Object[0])));
        buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton previewButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.DOCUMENT_NOTEBOOK, (String)this.getLocalized("org.teamapps.dictionary.preview", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.preview", new Object[0])));
        ToolbarButton editButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.EDIT, (String)this.getLocalized("org.teamapps.dictionary.edit", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.edit", new Object[0])));
        buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton translationsButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.EARTH, (Icon)FlagIcon.GB_GREAT_BRITAIN), (String)this.getLocalized("newsBoard.translations", new Object[0]), (String)this.getLocalized("newsBoard.showHideTranslations", new Object[0])));
        ToolbarButton showOriginalButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.FORM, (String)this.getLocalized("newsBoard.showOriginal", new Object[0]), (String)this.getLocalized("newsBoard.showOriginalMessage", new Object[0])));
        buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton publishButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.NEWSPAPER, (String)this.getLocalized("newsBoard.publish", new Object[0]), (String)this.getLocalized("newsBoard.publish", new Object[0])));
        ToolbarButton publishWithTranslationsButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.NEWSPAPER, (Icon)ApplicationIcons.EARTH), (String)this.getLocalized("newsBoard.publishWithTranslation", new Object[0]), (String)this.getLocalized("newsBoard.publishWithTranslation", new Object[0])));
        ToolbarButton addTranslationsButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.EARTH, (Icon)ApplicationIcons.ADD), (String)this.getLocalized("newsBoard.addTranslations", new Object[0]), (String)this.getLocalized("newsBoard.addTranslations", new Object[0])));
        buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton hideButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.NEWSPAPER, (Icon)ApplicationIcons.SIGN_FORBIDDEN), (String)this.getLocalized("org.teamapps.dictionary.hide", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.hide", new Object[0])));
        buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton imagesButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.PHOTO_LANDSCAPE, (String)this.getLocalized("newsBoard.images", new Object[0]), (String)this.getLocalized("newsBoard.showHideImages", new Object[0])));
        buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton deleteButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ERROR, (String)this.getLocalized("org.teamapps.dictionary.delete", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.deleteRecord", new Object[0])));
        buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton cancelAndCloseButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.WINDOW_CLOSE, (String)this.getLocalized("org.teamapps.dictionary.cancel", new Object[0]), (String)this.getLocalized("org.teamapps.dictionary.cancelClose", new Object[0])));
        cancelAndCloseButton.onClick.addListener(() -> this.window.close());
        LanguageSelectionView languageSelectionView = new LanguageSelectionView(this.getApplicationInstanceData());
        languageSelectionView.onLanguageSelection.addListener(this::handleLanguageSelection);
        languageView.setComponent(languageSelectionView.getComponent());
        ImageListView imageListView = new ImageListView(this.getApplicationInstanceData());
        imageListView.setImages(new ArrayList<NewsBoardMessageImage>(message.getImages()));
        imageView.setComponent(imageListView.getComponent());
        buttonGroup = imageView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton addImageButton = buttonGroup.addButton(ToolbarButton.createTiny((Icon)ApplicationIcons.ADD, (String)this.getLocalized("org.teamapps.dictionary.add", new Object[0])));
        ToolbarButton deleteImageButton = buttonGroup.addButton(ToolbarButton.createTiny((Icon)ApplicationIcons.ERROR, (String)this.getLocalized("org.teamapps.dictionary.delete", new Object[0])));
        addImageButton.onClick.addListener(() -> UploadDialogue.createMultiFileUploadDialogue(files -> {
            List<NewsBoardMessageImage> imageList = files.stream().map(file -> this.createImage(message, (FileItem)file)).filter(Objects::nonNull).collect(Collectors.toList());
            imageListView.addImages(imageList);
        }, Arrays.asList(".jpg", ".jpeg", "png", ".JPG", ".PNG"), this.getApplicationInstanceData()));
        deleteImageButton.onClick.addListener(() -> {
            NewsBoardMessageImage selectedImage = imageListView.getSelectedImage();
            if (selectedImage != null) {
                message.removeImages(selectedImage);
                imageListView.removeSelectedImage();
            }
        });
        this.editorView = new EditorView(this.getApplicationInstanceData());
        this.editorView.onTextUpdate.addListener(this::handleEditorUpdate);
        showOriginalButton.setVisible(false);
        if (message.isPublished()) {
            publishButton.setVisible(false);
            publishWithTranslationsButton.setVisible(false);
            addTranslationsButton.setVisible(true);
            hideButton.setVisible(true);
            languageSelectionView.setLanguages(NewsBoardUtils.getUsedLanguageValues(Collections.singletonList(message)));
        } else {
            publishButton.setVisible(true);
            publishWithTranslationsButton.setVisible(true);
            addTranslationsButton.setVisible(false);
            hideButton.setVisible(false);
            languageSelectionView.setLanguages(NewsBoardUtils.getUsedLanguageValues(Collections.singletonList(message)));
        }
        if (message.isStored()) {
            editButton.setVisible(true);
            previewButton.setVisible(false);
            saveButton.setVisible(false);
            deleteButton.setVisible(true);
            MessageView messageView = new MessageView(message, applicationInstanceData, (List<String>)this.getUser().getRankedLanguages(), null);
            this.centerView.setComponent(messageView.getComponent());
        } else {
            editButton.setVisible(false);
            previewButton.setVisible(true);
            saveButton.setVisible(true);
            deleteButton.setVisible(false);
            this.editorView.showMessage(message.getHtmlMessage());
            this.centerView.setComponent(this.editorView.getComponent());
            this.activeEditor = true;
        }
        editButton.onClick.addListener(() -> {
            editButton.setVisible(false);
            previewButton.setVisible(true);
            saveButton.setVisible(true);
            this.activeEditor = true;
            this.updateView();
        });
        previewButton.onClick.addListener(() -> {
            editButton.setVisible(true);
            previewButton.setVisible(false);
            saveButton.setVisible(false);
            this.activeEditor = false;
            this.updateView();
        });
        saveButton.onClick.addListener(() -> {
            if (this.selectedTranslation != null) {
                this.selectedTranslation.save();
            }
            if (message.getHtmlMessage() != null) {
                message.save();
                addTranslationsButton.setVisible(true);
            }
        });
        deleteButton.onClick.addListener(() -> {
            message.delete();
            newsBoardPerspective.updateMessages();
            this.window.close();
        });
        hideButton.onClick.addListener(() -> message.setPublished(false));
        imagesButton.onClick.addListener(() -> imageView.setVisible(!imageView.isVisible()));
        translationsButton.onClick.addListener(() -> languageView.setVisible(!languageView.isVisible()));
        addTranslationsButton.onClick.addListener(() -> {
            if (message.getHtmlMessage() == null || message.getHtmlMessage().isBlank()) {
                return;
            }
            new TranslationSelectionDialogue(message, false, registry.getSystemConfig().getLocalizationConfig(), registry.getTranslationService(), () -> languageSelectionView.setLanguages(NewsBoardUtils.getUsedLanguageValues(Collections.singletonList(message))), this.getApplicationInstanceData());
        });
        publishWithTranslationsButton.onClick.addListener(() -> {
            if (message.getHtmlMessage() == null || message.getHtmlMessage().isBlank()) {
                return;
            }
            new TranslationSelectionDialogue(message, true, registry.getSystemConfig().getLocalizationConfig(), registry.getTranslationService(), () -> {
                message.setPublished(true).save();
                this.window.close();
                newsBoardPerspective.updateMessages();
            }, this.getApplicationInstanceData());
        });
        publishButton.onClick.addListener(() -> {
            if (message.getHtmlMessage() != null) {
                message.setPublished(true).save();
                this.window.close();
                newsBoardPerspective.updateMessages();
            }
        });
        if (!this.isAllowed(MessagingPrivileges.NEWS_BOARD_ADMIN_ACCESS)) {
            return;
        }
        this.application.showPerspective(perspective);
        this.window = new Window(1100, 800, this.application.getUi());
        this.window.setIcon(ApplicationIcons.MESSAGE);
        this.window.setTitle(this.getLocalized("newsBoard.message", new Object[0]));
        this.window.setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.3f));
        this.window.setMaximizable(true);
        this.window.setCloseable(true);
        this.window.setCloseOnEscape(true);
        this.window.show();
    }

    private void handleLanguageSelection(String language) {
        this.selectedLanguage.set((Object)language);
        this.updateView();
    }

    private void updateView() {
        String language = (String)this.selectedLanguage.get();
        NewsBoardMessageTranslation messageTranslation = this.message.getTranslations().stream().filter(translation -> translation.getLanguage().equals(language)).findFirst().orElse(null);
        this.selectedTranslation = messageTranslation != null ? messageTranslation : null;
        if (this.activeEditor) {
            if (this.selectedTranslation != null) {
                this.editorView.showMessage(this.selectedTranslation.getTranslation());
            } else {
                this.editorView.showMessage(this.message.getHtmlMessage());
            }
            this.centerView.setComponent(this.editorView.getComponent());
        } else {
            MessageView messageView = this.selectedTranslation != null ? new MessageView(this.message, this.getApplicationInstanceData(), Collections.singletonList(language), null) : new MessageView(this.message, this.getApplicationInstanceData(), (List<String>)this.getUser().getRankedLanguages(), null);
            this.centerView.setComponent(messageView.getComponent());
        }
    }

    private void handleEditorUpdate(String text) {
        if (this.selectedTranslation != null) {
            this.selectedTranslation.setTranslation(text);
        } else {
            this.message.setHtmlMessage(text);
        }
    }

    private NewsBoardMessageImage createImage(NewsBoardMessage message, FileItem fileItem) {
        try {
            File file = fileItem.getFile();
            File tempFile = File.createTempFile("temp", ".jpg");
            Thumbnailator.createThumbnail((File)file, (File)tempFile, (int)100, (int)100);
            NewsBoardMessageImage messageImage = NewsBoardMessageImage.create().setFile(file).setFileName(fileItem.getFileName()).setThumbnail(tempFile).setPosition(0);
            message.addImages(messageImage);
            return messageImage;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

