/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.messaging.newsboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.messaging.MessagingPrivileges;
import org.teamapps.application.server.messaging.newsboard.MessageWindow;
import org.teamapps.application.server.messaging.newsboard.NewsBoardUtils;
import org.teamapps.application.server.messaging.newsboard.views.MessageView;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.NewsBoardMessage;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.combobox.ComboBox;

public class NewsBoardPerspective
extends AbstractManagedApplicationPerspective {
    private View masterView;
    private final UserSessionData userSessionData;

    public NewsBoardPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        this.masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.MESSAGE, (String)this.getLocalized("newsBoard.title"), null));
        this.masterView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.1f));
        this.updateMessages();
        if (this.isAllowed(MessagingPrivileges.NEWS_BOARD_ADMIN_ACCESS)) {
            Button addButton = Button.create((Icon)ApplicationIcons.ADD, (String)this.getLocalized("org.teamapps.dictionary.add"));
            this.masterView.getPanel().setRightHeaderField((AbstractField)addButton);
            addButton.onClicked.addListener(() -> this.showMessageWindow(null));
        }
    }

    public void updateMessages() {
        this.updateMessages(this.getUser().getRankedLanguages());
    }

    public void updateMessages(List<String> rankedLanguages) {
        List<NewsBoardMessage> messages = this.isAppFilter() ? NewsBoardMessage.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())).execute() : NewsBoardMessage.getAll();
        messages = new ArrayList<NewsBoardMessage>(messages);
        ComboBox<String> languageComboBox = NewsBoardUtils.createLanguageSelectionComboBox(NewsBoardUtils.getUsedLanguageValues(messages), this.getApplicationInstanceData());
        this.masterView.getPanel().setLeftHeaderField(languageComboBox);
        Collections.reverse(messages);
        MessageView messageView = new MessageView(messages, this.getApplicationInstanceData(), rankedLanguages, this::showMessageWindow);
        this.masterView.setComponent(messageView.getComponent());
        languageComboBox.setValue((Object)rankedLanguages.get(0));
        languageComboBox.onValueChanged.addListener(language -> {
            if ("user-languages".equals(language)) {
                this.updateMessages();
            } else {
                this.updateMessages(Collections.singletonList(language));
            }
        });
    }

    private void showMessageWindow(NewsBoardMessage message) {
        if (!this.isAllowed(MessagingPrivileges.NEWS_BOARD_ADMIN_ACCESS)) {
            return;
        }
        if (message == null) {
            message = NewsBoardMessage.create().setLanguage(this.getUser().getLocale().getLanguage()).setMetaCreatedBy(this.getUser().getId()).setOrganizationField(this.getOrganizationField());
        }
        new MessageWindow(message, this, this.getApplicationInstanceData(), this.userSessionData.getRegistry());
    }
}

