/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.session;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.perspective.PerspectiveBuilder;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.api.desktop.ApplicationDesktop;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.organization.UserRoleType;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.ui.UiComponentFactory;
import org.teamapps.application.api.user.SessionUser;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.session.ManagedApplicationSessionData;
import org.teamapps.application.server.system.session.SessionUiComponentFactory;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.LogLevel;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationFieldView;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.model.controlcenter.RoleType;
import org.teamapps.model.controlcenter.SystemLog;
import org.teamapps.model.controlcenter.UserRoleAssignment;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.component.progress.MultiProgressDisplay;

public class PerspectiveSessionData
implements ApplicationInstanceData {
    private final ManagedApplicationSessionData managedApplicationSessionData;
    private final ManagedApplication managedApplication;
    private final ManagedApplicationPerspective managedApplicationPerspective;
    private final PerspectiveBuilder perspectiveBuilder;
    private final ApplicationPrivilegeProvider privilegeProvider;
    private final ApplicationLocalizationProvider localizationProvider;
    private final Supplier<DocumentConverter> documentConverterSupplier;
    private final UserSessionData userSessionData;
    private final SessionUiComponentFactory componentFactory;

    public PerspectiveSessionData(ManagedApplicationSessionData managedApplicationSessionData, ManagedApplication managedApplication, ManagedApplicationPerspective managedApplicationPerspective, PerspectiveBuilder perspectiveBuilder, ApplicationPrivilegeProvider privilegeProvider, ApplicationLocalizationProvider localizationProvider, Supplier<DocumentConverter> documentConverterSupplier) {
        this.managedApplicationSessionData = managedApplicationSessionData;
        this.managedApplication = managedApplication;
        this.managedApplicationPerspective = managedApplicationPerspective;
        this.perspectiveBuilder = perspectiveBuilder;
        this.privilegeProvider = privilegeProvider;
        this.localizationProvider = localizationProvider;
        this.documentConverterSupplier = documentConverterSupplier;
        this.userSessionData = managedApplicationSessionData.getUserSessionData();
        this.componentFactory = new SessionUiComponentFactory(this, this.userSessionData.getRegistry(), managedApplication.getMainApplication());
    }

    public Icon getIcon() {
        if (this.managedApplicationPerspective.getIconOverride() != null) {
            return IconUtils.decodeIcon((String)this.managedApplicationPerspective.getIconOverride());
        }
        return this.perspectiveBuilder.getIcon();
    }

    public String getTitle() {
        if (this.managedApplicationPerspective.getTitleKeyOverride() != null) {
            return this.localizationProvider.getLocalized(this.managedApplicationPerspective.getTitleKeyOverride(), new Object[0]);
        }
        return this.localizationProvider.getLocalized(this.perspectiveBuilder.getTitleKey(), new Object[0]);
    }

    public String getDescription() {
        if (this.managedApplicationPerspective.getDescriptionKeyOverride() != null) {
            return this.localizationProvider.getLocalized(this.managedApplicationPerspective.getDescriptionKeyOverride(), new Object[0]);
        }
        return this.localizationProvider.getLocalized(this.perspectiveBuilder.getDescriptionKey(), new Object[0]);
    }

    public ManagedApplicationPerspective getManagedApplicationPerspective() {
        return this.managedApplicationPerspective;
    }

    public ManagedApplicationSessionData getManagedApplicationSessionData() {
        return this.managedApplicationSessionData;
    }

    public PerspectiveBuilder getPerspectiveBuilder() {
        return this.perspectiveBuilder;
    }

    public SessionUser getUser() {
        return this.managedApplicationSessionData.getUserSessionData().getSessionUser();
    }

    public OrganizationFieldView getOrganizationField() {
        return this.managedApplicationSessionData.getOrganizationFieldView();
    }

    public int getManagedApplicationId() {
        return this.managedApplication.getId();
    }

    public DocumentConverter getDocumentConverter() {
        return this.documentConverterSupplier != null ? this.documentConverterSupplier.get() : null;
    }

    public MultiProgressDisplay getMultiProgressDisplay() {
        return this.managedApplicationSessionData.getResponsiveApplication().getMultiProgressDisplay();
    }

    public void showPerspective(Perspective perspective) {
        this.managedApplicationSessionData.getResponsiveApplication().showPerspective(perspective);
    }

    public ApplicationDesktop createApplicationDesktop() {
        return this.userSessionData.getApplicationDesktopSupplier().get();
    }

    public UiComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public boolean isDarkTheme() {
        return this.managedApplication.getDarkTheme();
    }

    public ApplicationConfig<?> getApplicationConfig() {
        return this.managedApplicationSessionData.getMainApplication().getBaseApplicationBuilder().getApplicationConfig();
    }

    public void writeActivityLog(String title, String data) {
        SystemLog.create().setManagedApplication(this.managedApplication).setManagedPerspective(this.managedApplicationPerspective).setApplication(this.managedApplicationPerspective.getApplicationPerspective().getApplication()).setLogLevel(LogLevel.INFO).setMessage(title).setDetails(data).save();
    }

    public void writeExceptionLog(String title, Throwable throwable) {
        SystemLog.create().setManagedApplication(this.managedApplication).setManagedPerspective(this.managedApplicationPerspective).setApplication(this.managedApplicationPerspective.getApplicationPerspective().getApplication()).setLogLevel(LogLevel.ERROR).setMessage(title).setDetails(ExceptionUtils.getStackTrace((Throwable)throwable)).save();
    }

    public Integer getOrganizationUserWithRole(OrganizationUnitView orgUnit, UserRoleType userRoleType) {
        List<Integer> organizationUsersWithRole = PerspectiveSessionData.getOrganizationUsersWithRole(orgUnit, userRoleType, false, this.getOrganizationField());
        if (organizationUsersWithRole != null && !organizationUsersWithRole.isEmpty()) {
            return organizationUsersWithRole.get(0);
        }
        return null;
    }

    public List<Integer> getOrganizationUsersWithRole(OrganizationUnitView orgUnit, UserRoleType userRoleType) {
        return PerspectiveSessionData.getOrganizationUsersWithRole(orgUnit, userRoleType, false, this.getOrganizationField());
    }

    public static List<Integer> getOrganizationUsersWithRole(OrganizationUnitView orgUnit, UserRoleType userRoleType, boolean mainResponsible, OrganizationFieldView organizationFieldView) {
        if (userRoleType == null) {
            return null;
        }
        RoleType roleType = switch (userRoleType) {
            case UserRoleType.LEADER -> RoleType.LEADER;
            case UserRoleType.ASSISTANT -> RoleType.ASSISTANT;
            case UserRoleType.MENTOR -> RoleType.MENTOR;
            case UserRoleType.ADMINISTRATOR -> RoleType.ADMINISTRATOR;
            case UserRoleType.OTHER -> RoleType.OTHER;
            default -> throw new IncompatibleClassChangeError();
        };
        OrganizationField organizationField = OrganizationUtils.convert(organizationFieldView);
        return UserRoleAssignment.filter().organizationUnit(NumericFilter.equalsFilter((Number)orgUnit.getId())).execute().stream().filter(userRoleAssignment -> organizationField == null || userRoleAssignment.getRole().getOrganizationField().equals(organizationField)).filter(userRoleAssignment -> userRoleAssignment.getRole().getRoleType() == roleType).filter(userRoleAssignment -> !mainResponsible || userRoleAssignment.isMainResponsible()).map(assignment -> assignment.getUser().getId()).collect(Collectors.toList());
    }

    public String getLocalized(String s, Object ... objects) {
        return this.localizationProvider.getLocalized(s, objects);
    }

    public String getLocalized(String key, List<String> languagePriorityOrder, Object ... parameters) {
        return this.localizationProvider.getLocalized(key, languagePriorityOrder, parameters);
    }

    public String getLocalized(TranslatableText translatableText) {
        return this.localizationProvider.getLocalized(translatableText);
    }

    public boolean isAllowed(SimplePrivilege simplePrivilege) {
        return this.privilegeProvider.isAllowed(simplePrivilege);
    }

    public boolean isAllowed(SimpleOrganizationalPrivilege simpleOrganizationalPrivilege, OrganizationUnitView organizationUnitView) {
        return this.privilegeProvider.isAllowed(simpleOrganizationalPrivilege, organizationUnitView);
    }

    public boolean isAllowed(SimpleCustomObjectPrivilege simpleCustomObjectPrivilege, PrivilegeObject privilegeObject) {
        return this.privilegeProvider.isAllowed(simpleCustomObjectPrivilege, privilegeObject);
    }

    public boolean isAllowed(StandardPrivilegeGroup standardPrivilegeGroup, Privilege privilege) {
        return this.privilegeProvider.isAllowed(standardPrivilegeGroup, privilege);
    }

    public boolean isAllowed(OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Privilege privilege, OrganizationUnitView organizationUnitView) {
        return this.privilegeProvider.isAllowed(organizationalPrivilegeGroup, privilege, organizationUnitView);
    }

    public boolean isAllowed(CustomObjectPrivilegeGroup customObjectPrivilegeGroup, Privilege privilege, PrivilegeObject privilegeObject) {
        return this.privilegeProvider.isAllowed(customObjectPrivilegeGroup, privilege, privilegeObject);
    }

    public List<OrganizationUnitView> getAllowedUnits(SimpleOrganizationalPrivilege simpleOrganizationalPrivilege) {
        return this.privilegeProvider.getAllowedUnits(simpleOrganizationalPrivilege);
    }

    public List<OrganizationUnitView> getAllowedUnits(OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Privilege privilege) {
        return this.privilegeProvider.getAllowedUnits(organizationalPrivilegeGroup, privilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege simpleCustomObjectPrivilege) {
        return this.privilegeProvider.getAllowedPrivilegeObjects(simpleCustomObjectPrivilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup customObjectPrivilegeGroup, Privilege privilege) {
        return this.privilegeProvider.getAllowedPrivilegeObjects(customObjectPrivilegeGroup, privilege);
    }
}

