package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbApplicationFolder extends AbstractUdbEntity<ApplicationFolder> implements ApplicationFolder {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static TextIndex name;
	protected static SingleReferenceIndex application;
	protected static ShortIndex applicationFolderType;
	protected static SingleReferenceIndex parent;
	protected static MultiReferenceIndex children;
	protected static MultiReferenceIndex messages;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		name = (TextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		application = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION);
		applicationFolderType = (ShortIndex) tableIndex.getColumnIndex(FIELD_APPLICATION_FOLDER_TYPE);
		parent = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_PARENT);
		children = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_CHILDREN);
		messages = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_MESSAGES);
    }

    public static List<ApplicationFolder> getAll() {
        return new EntityBitSetList<>(ApplicationFolder.getBuilder(), table.getRecordBitSet());
    }

    public static List<ApplicationFolder> getDeletedRecords() {
        return new EntityBitSetList<>(ApplicationFolder.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<ApplicationFolder> sort(List<ApplicationFolder> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<ApplicationFolder> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, ApplicationFolder.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbApplicationFolder() {
        super(table);
    }

    public UdbApplicationFolder(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public ApplicationFolder build() {
        return new UdbApplicationFolder();
    }

    @Override
    public ApplicationFolder build(int id) {
        return new UdbApplicationFolder(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public ApplicationFolder setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public ApplicationFolder setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public ApplicationFolder setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public ApplicationFolder setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public ApplicationFolder setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public ApplicationFolder setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public ApplicationFolder setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public ApplicationFolder setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public ApplicationFolder setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public ApplicationFolder setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public ApplicationFolder setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public ApplicationFolder setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public ApplicationFolder setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public ApplicationFolder setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public ApplicationFolder setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public ApplicationFolder setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public String getName() {
        return getTextValue(name);
	}

	@Override
	public ApplicationFolder setName(String value) {
	    setTextValue(value, this.name);
		return this;
	}

	@Override
	public Application getApplication() {
		if (isChanged(application)) {
			return (Application) getReferenceChangeValue(application);
		} else {
			int id = application.getValue(getId());
			if (id > 0) {
				return Application.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ApplicationFolder setApplication(Application value) {
		setSingleReferenceValue(application, value, table);
		return this;
	}

	@Override
	public ApplicationFolderType getApplicationFolderType() {
	    return getEnumValue(applicationFolderType, ApplicationFolderType.values());
	}

	@Override
	public ApplicationFolder setApplicationFolderType(ApplicationFolderType value) {
    	setEnumValue(this.applicationFolderType, value);
		return this;
	}

	@Override
	public ApplicationFolder getParent() {
		if (isChanged(parent)) {
			return (ApplicationFolder) getReferenceChangeValue(parent);
		} else {
			int id = parent.getValue(getId());
			if (id > 0) {
				return ApplicationFolder.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ApplicationFolder setParent(ApplicationFolder value) {
		setSingleReferenceValue(parent, value, table);
		return this;
	}

	@Override
	public List<ApplicationFolder> getChildren() {
	    return getMultiReferenceValue(children, ApplicationFolder.getBuilder());
	}

	@Override
	public ApplicationFolder setChildren(List<ApplicationFolder> value) {
		setMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public int getChildrenCount() {
	    return getMultiReferenceValueCount(children, ApplicationFolder.getBuilder());
	}

	@Override
	public ApplicationFolder setChildren(ApplicationFolder ... value) {
		setMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public BitSet getChildrenAsBitSet() {
	    return getMultiReferenceValueAsBitSet(children, ApplicationFolder.getBuilder());
	}

	@Override
	public ApplicationFolder addChildren(List<ApplicationFolder> value) {
		addMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public ApplicationFolder addChildren(ApplicationFolder ... value) {
		addMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public ApplicationFolder removeChildren(List<ApplicationFolder> value) {
		removeMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public ApplicationFolder removeChildren(ApplicationFolder ... value) {
		removeMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public ApplicationFolder removeAllChildren() {
		removeAllMultiReferenceValue(children);
		return this;
	}

	@Override
	public List<Message> getMessages() {
	    return getMultiReferenceValue(messages, Message.getBuilder());
	}

	@Override
	public ApplicationFolder setMessages(List<Message> value) {
		setMultiReferenceValue(value, messages);
		return this;
	}

	@Override
	public int getMessagesCount() {
	    return getMultiReferenceValueCount(messages, Message.getBuilder());
	}

	@Override
	public ApplicationFolder setMessages(Message ... value) {
		setMultiReferenceValue(Arrays.asList(value), messages);
		return this;
	}

	@Override
	public BitSet getMessagesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(messages, Message.getBuilder());
	}

	@Override
	public ApplicationFolder addMessages(List<Message> value) {
		addMultiReferenceValue(value, messages);
		return this;
	}

	@Override
	public ApplicationFolder addMessages(Message ... value) {
		addMultiReferenceValue(Arrays.asList(value), messages);
		return this;
	}

	@Override
	public ApplicationFolder removeMessages(List<Message> value) {
		removeMultiReferenceValue(value, messages);
		return this;
	}

	@Override
	public ApplicationFolder removeMessages(Message ... value) {
		removeMultiReferenceValue(Arrays.asList(value), messages);
		return this;
	}

	@Override
	public ApplicationFolder removeAllMessages() {
		removeAllMultiReferenceValue(messages);
		return this;
	}


    @Override
    public UdbApplicationFolder save(Transaction transaction, boolean strictChangeVerification) {
        saveRecord(transaction, strictChangeVerification);
        return this;
    }

    @Override
    public UdbApplicationFolder saveTransactional(boolean strictChangeVerification) {
        saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    @Override
    public UdbApplicationFolder save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        deleteRecord(transaction);
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



