package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbAppointmentSeriesQuery extends AbstractUdbQuery<AppointmentSeries> implements AppointmentSeriesQuery {

    public UdbAppointmentSeriesQuery() {
        super(UdbAppointmentSeries.table, AppointmentSeries.getBuilder());
    }

	@Override
	public AppointmentSeriesQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbAppointmentSeries.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public AppointmentSeriesQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbAppointmentSeries.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public AppointmentSeriesQuery metaCreationDate(NumericFilter filter) {
		and(UdbAppointmentSeries.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbAppointmentSeries.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery metaCreatedBy(NumericFilter filter) {
		and(UdbAppointmentSeries.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbAppointmentSeries.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery metaModificationDate(NumericFilter filter) {
		and(UdbAppointmentSeries.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbAppointmentSeries.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery metaModifiedBy(NumericFilter filter) {
		and(UdbAppointmentSeries.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbAppointmentSeries.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery metaDeletionDate(NumericFilter filter) {
		and(UdbAppointmentSeries.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbAppointmentSeries.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery metaDeletedBy(NumericFilter filter) {
		and(UdbAppointmentSeries.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbAppointmentSeries.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery metaRestoreDate(NumericFilter filter) {
		and(UdbAppointmentSeries.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbAppointmentSeries.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery metaRestoredBy(NumericFilter filter) {
		and(UdbAppointmentSeries.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbAppointmentSeries.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery filterMessage(MessageQuery query) {
		UdbMessageQuery udbQuery = (UdbMessageQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbAppointmentSeries.message, UdbMessage.appointmentSeries);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public AppointmentSeriesQuery message(NumericFilter filter) {
		and(UdbAppointmentSeries.message.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orMessage(NumericFilter filter) {
		or(UdbAppointmentSeries.message.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery filterAppointments(AppointmentQuery query) {
		UdbAppointmentQuery udbQuery = (UdbAppointmentQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbAppointmentSeries.appointments, UdbAppointment.appointmentSeries);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public AppointmentSeriesQuery appointments(MultiReferenceFilterType type, Appointment ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (Appointment value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbAppointmentSeries.appointments.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery appointmentsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbAppointmentSeries.appointments.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery appointments(MultiReferenceFilter filter) {
		and(UdbAppointmentSeries.appointments.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orAppointments(MultiReferenceFilter filter) {
		or(UdbAppointmentSeries.appointments.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery appointmentSeriesType(EnumFilterType filterType, AppointmentSeriesType... enums) {
		and(UdbAppointmentSeries.appointmentSeriesType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orAppointmentSeriesType(EnumFilterType filterType, AppointmentSeriesType... enums) {
		or(UdbAppointmentSeries.appointmentSeriesType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public AppointmentSeriesQuery repeatEvery(NumericFilter filter) {
		and(UdbAppointmentSeries.repeatEvery.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orRepeatEvery(NumericFilter filter) {
		or(UdbAppointmentSeries.repeatEvery.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery startDateTime(NumericFilter filter) {
		and(UdbAppointmentSeries.startDateTime.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orStartDateTime(NumericFilter filter) {
		or(UdbAppointmentSeries.startDateTime.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery endDateTime(NumericFilter filter) {
		and(UdbAppointmentSeries.endDateTime.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orEndDateTime(NumericFilter filter) {
		or(UdbAppointmentSeries.endDateTime.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery fullDayEvent(BooleanFilter filter) {
		and(UdbAppointmentSeries.fullDayEvent.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orFullDayEvent(BooleanFilter filter) {
		or(UdbAppointmentSeries.fullDayEvent.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery seriesEndDate(NumericFilter filter) {
		and(UdbAppointmentSeries.seriesEndDate.createFilter(filter));
		return this;
	}

	@Override
	public AppointmentSeriesQuery orSeriesEndDate(NumericFilter filter) {
		or(UdbAppointmentSeries.seriesEndDate.createFilter(filter));
		return this;
	}


	@Override
	public UdbAppointmentSeriesQuery andOr(AppointmentSeriesQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public AppointmentSeriesQuery customFilter(Function<AppointmentSeries, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(AppointmentSeries.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



