package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbUserRoleAssignmentQuery extends AbstractUdbQuery<UserRoleAssignment> implements UserRoleAssignmentQuery {

    public UdbUserRoleAssignmentQuery() {
        super(UdbUserRoleAssignment.table, UserRoleAssignment.getBuilder());
    }

	@Override
	public UserRoleAssignmentQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbUserRoleAssignment.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbUserRoleAssignment.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery metaCreationDate(NumericFilter filter) {
		and(UdbUserRoleAssignment.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbUserRoleAssignment.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery metaCreatedBy(NumericFilter filter) {
		and(UdbUserRoleAssignment.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbUserRoleAssignment.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery metaModificationDate(NumericFilter filter) {
		and(UdbUserRoleAssignment.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbUserRoleAssignment.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery metaModifiedBy(NumericFilter filter) {
		and(UdbUserRoleAssignment.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbUserRoleAssignment.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery metaDeletionDate(NumericFilter filter) {
		and(UdbUserRoleAssignment.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbUserRoleAssignment.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery metaDeletedBy(NumericFilter filter) {
		and(UdbUserRoleAssignment.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbUserRoleAssignment.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery metaRestoreDate(NumericFilter filter) {
		and(UdbUserRoleAssignment.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbUserRoleAssignment.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery metaRestoredBy(NumericFilter filter) {
		and(UdbUserRoleAssignment.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbUserRoleAssignment.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery filterUser(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserRoleAssignment.user, UdbUser.roleAssignments);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserRoleAssignmentQuery user(NumericFilter filter) {
		and(UdbUserRoleAssignment.user.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orUser(NumericFilter filter) {
		or(UdbUserRoleAssignment.user.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery filterRole(RoleQuery query) {
		UdbRoleQuery udbQuery = (UdbRoleQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserRoleAssignment.role, UdbRole.userRoleAssignments);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserRoleAssignmentQuery role(NumericFilter filter) {
		and(UdbUserRoleAssignment.role.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orRole(NumericFilter filter) {
		or(UdbUserRoleAssignment.role.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery filterOrganizationUnit(OrganizationUnitQuery query) {
		UdbOrganizationUnitQuery udbQuery = (UdbOrganizationUnitQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserRoleAssignment.organizationUnit);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserRoleAssignmentQuery organizationUnit(NumericFilter filter) {
		and(UdbUserRoleAssignment.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orOrganizationUnit(NumericFilter filter) {
		or(UdbUserRoleAssignment.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery mainResponsible(BooleanFilter filter) {
		and(UdbUserRoleAssignment.mainResponsible.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orMainResponsible(BooleanFilter filter) {
		or(UdbUserRoleAssignment.mainResponsible.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery lastVerified(NumericFilter filter) {
		and(UdbUserRoleAssignment.lastVerified.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orLastVerified(NumericFilter filter) {
		or(UdbUserRoleAssignment.lastVerified.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery filterLastVerifiedBy(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserRoleAssignment.lastVerifiedBy);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserRoleAssignmentQuery lastVerifiedBy(NumericFilter filter) {
		and(UdbUserRoleAssignment.lastVerifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserRoleAssignmentQuery orLastVerifiedBy(NumericFilter filter) {
		or(UdbUserRoleAssignment.lastVerifiedBy.createFilter(filter));
		return this;
	}


	@Override
	public UdbUserRoleAssignmentQuery andOr(UserRoleAssignmentQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public UserRoleAssignmentQuery customFilter(Function<UserRoleAssignment, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(UserRoleAssignment.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



