/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.teamapps.application.api.application.ApplicationBuilder;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.server.system.bootstrap.ApplicationInfoDataElement;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationVersion;
import org.teamapps.universaldb.index.text.TextFilter;

public class ApplicationInfo {
    private BaseApplicationBuilder baseApplicationBuilder;
    private File applicationJar;
    private ClassLoader applicationClassLoader;
    private boolean unmanagedPerspectives;
    private String name;
    private String binaryHash;
    private String version;
    private String releaseNotes;
    private List<String> warnings = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();
    private ApplicationInfoDataElement dataModelData;
    private ApplicationInfoDataElement localizationData;
    private ApplicationInfoDataElement privilegeData;
    private ApplicationInfoDataElement perspectiveData;
    private boolean checked;
    private Application application;
    private ApplicationVersion applicationVersion;
    private LoadedApplication loadedApplication;

    public ApplicationInfo(BaseApplicationBuilder baseApplicationBuilder) {
        this.baseApplicationBuilder = baseApplicationBuilder;
        if (!(baseApplicationBuilder instanceof ApplicationBuilder)) {
            this.unmanagedPerspectives = true;
        }
    }

    public ApplicationInfo(File applicationJar) {
        this.applicationJar = applicationJar;
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public Application getApplication() {
        if (this.application == null && this.getName() != null) {
            this.application = Application.filter().name(TextFilter.textEqualsFilter((String)this.getName())).executeExpectSingleton();
        }
        return this.application;
    }

    public void createLoadedApplication() {
        this.loadedApplication = new LoadedApplication(this.getApplication(), this.baseApplicationBuilder, this.applicationClassLoader, this.unmanagedPerspectives);
    }

    public LoadedApplication getLoadedApplication() {
        return this.loadedApplication;
    }

    public BaseApplicationBuilder getBaseApplicationBuilder() {
        return this.baseApplicationBuilder;
    }

    public void setBaseApplicationBuilder(BaseApplicationBuilder baseApplicationBuilder) {
        this.baseApplicationBuilder = baseApplicationBuilder;
    }

    public File getApplicationJar() {
        return this.applicationJar;
    }

    public void setApplicationJar(File applicationJar) {
        this.applicationJar = applicationJar;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBinaryHash() {
        return this.binaryHash;
    }

    public void setBinaryHash(String binaryHash) {
        this.binaryHash = binaryHash;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    public void setReleaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public String getWarningMessage() {
        return this.warnings.isEmpty() ? null : String.join((CharSequence)", ", this.warnings);
    }

    public String getErrorMessage() {
        return this.errors.isEmpty() ? null : String.join((CharSequence)", ", this.errors);
    }

    public ApplicationInfoDataElement getDataModelData() {
        return this.dataModelData;
    }

    public void setDataModelData(ApplicationInfoDataElement dataModelData) {
        this.dataModelData = dataModelData;
    }

    public ApplicationInfoDataElement getLocalizationData() {
        return this.localizationData;
    }

    public void setLocalizationData(ApplicationInfoDataElement localizationData) {
        this.localizationData = localizationData;
    }

    public ApplicationInfoDataElement getPrivilegeData() {
        return this.privilegeData;
    }

    public void setPrivilegeData(ApplicationInfoDataElement privilegeData) {
        this.privilegeData = privilegeData;
    }

    public ApplicationInfoDataElement getPerspectiveData() {
        return this.perspectiveData;
    }

    public void setPerspectiveData(ApplicationInfoDataElement perspectiveData) {
        this.perspectiveData = perspectiveData;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public void setApplicationClassLoader(ClassLoader applicationClassLoader) {
        this.applicationClassLoader = applicationClassLoader;
    }

    public boolean isUnmanagedPerspectives() {
        return this.unmanagedPerspectives;
    }

    public void setUnmanagedPerspectives(boolean unmanagedPerspectives) {
        this.unmanagedPerspectives = unmanagedPerspectives;
    }

    public ApplicationVersion getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(ApplicationVersion applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String toString() {
        return "ApplicationInfo{applicationBuilder=" + this.baseApplicationBuilder + ", applicationJar=" + this.applicationJar + ", applicationClassLoader=" + this.applicationClassLoader + ", unmanagedPerspectives=" + this.unmanagedPerspectives + ", name='" + this.name + "', binaryHash='" + this.binaryHash + "', version='" + this.version + "', releaseNotes='" + this.releaseNotes + "', warnings=" + this.warnings + ", errors=" + this.errors + ", dataModelData=" + this.dataModelData + ", localizationData=" + this.localizationData + ", privilegeData=" + this.privilegeData + ", perspectiveData=" + this.perspectiveData + ", checked=" + this.checked + ", application=" + this.application + ", applicationVersion=" + this.applicationVersion + ", loadedApplication=" + this.loadedApplication + "}";
    }
}

