/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.utils;

import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.model.controlcenter.ApplicationPrivilegeGroup;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.model.controlcenter.Role;
import org.teamapps.model.controlcenter.RoleApplicationRoleAssignment;
import org.teamapps.model.controlcenter.RolePrivilegeAssignment;
import org.teamapps.model.controlcenter.UserRoleAssignment;

public class RoleUtils {
    public static Set<Role> getAllRoleInstances(Role role) {
        HashSet<Role> roleSet = new HashSet<Role>();
        RoleUtils.calculateRoleInstances(role, roleSet);
        return roleSet;
    }

    private static void calculateRoleInstances(Role role, Set<Role> roleSet) {
        if (!roleSet.contains(role)) {
            roleSet.add(role);
            for (Role specializationRole : role.getSpecializationRoles()) {
                RoleUtils.calculateRoleInstances(specializationRole, roleSet);
            }
        }
    }

    public static Set<Role> getAllPrivilegeRoles(Role role) {
        HashSet<Role> roleSet = new HashSet<Role>();
        RoleUtils.calculatePrivilegeRoles(role, roleSet);
        return roleSet;
    }

    private static void calculatePrivilegeRoles(Role role, Set<Role> roleSet) {
        if (!roleSet.contains(role)) {
            roleSet.add(role);
            for (Role generalizationRole : role.getGeneralizationRoles()) {
                RoleUtils.calculatePrivilegeRoles(generalizationRole, roleSet);
            }
            for (Role privilegesSendingRole : role.getPrivilegesSendingRoles()) {
                RoleUtils.calculatePrivilegeRoles(privilegesSendingRole, roleSet);
            }
        }
    }

    public static List<UserRoleAssignment> getUserRoleAssignments(Role role, boolean withSpecializationRoles, OrganizationUnit organizationUnit, List<OrganizationUnitType> organizationUnitTypesFilter) {
        if (role == null || organizationUnit == null) {
            return Collections.emptyList();
        }
        HashSet<Role> roleSet = withSpecializationRoles ? RoleUtils.getAllRoleInstances(role) : new HashSet<Role>(Collections.singletonList(role));
        Set<OrganizationUnit> allUnits = OrganizationUtils.getAllUnits(organizationUnit, organizationUnitTypesFilter);
        return RoleUtils.getUserRoleAssignments(roleSet, allUnits);
    }

    public static List<UserRoleAssignment> getUserRoleAssignments(Set<Role> roleSet, Set<OrganizationUnit> organizationUnits) {
        return UserRoleAssignment.getAll().stream().filter(assignment -> roleSet.contains(assignment.getRole())).filter(assignment -> organizationUnits.contains(assignment.getOrganizationUnit())).collect(Collectors.toList());
    }

    public static int getMemberCount(Role role, boolean withSpecializationRoles) {
        HashSet<Role> roleSet = withSpecializationRoles ? RoleUtils.getAllRoleInstances(role) : new HashSet<Role>(Collections.singletonList(role));
        return (int)UserRoleAssignment.getAll().stream().filter(assignment -> roleSet.contains(assignment.getRole())).count();
    }

    public static List<UserRoleAssignment> getMembers(Role role, boolean withSpecializationRoles) {
        HashSet<Role> roleSet = withSpecializationRoles ? RoleUtils.getAllRoleInstances(role) : new HashSet<Role>(Collections.singletonList(role));
        return UserRoleAssignment.getAll().stream().filter(assignment -> roleSet.contains(assignment.getRole())).collect(Collectors.toList());
    }

    public static List<ApplicationPrivilegeGroup> calculateRolePrivileges(Role role, SystemRegistry systemRegistry) {
        HashMap<CallSite, ApplicationRole> applicationRoleMap = new HashMap<CallSite, ApplicationRole>();
        for (LoadedApplication loadedApplication : systemRegistry.getLoadedApplications()) {
            String name = loadedApplication.getApplication().getName();
            List applicationRoles = loadedApplication.getBaseApplicationBuilder().getApplicationRoles();
            if (applicationRoles == null) continue;
            for (ApplicationRole applicationRole : applicationRoles) {
                applicationRoleMap.put((CallSite)((Object)(name + "." + applicationRole.getName())), applicationRole);
            }
        }
        HashMap groupMap = new HashMap();
        ApplicationPrivilegeGroup.getAll().forEach(group -> groupMap.put(group.getApplication().getName() + "." + group.getName(), group));
        Set<Role> privilegeRoles = RoleUtils.getAllPrivilegeRoles(role);
        for (Role privilegeRole : privilegeRoles) {
            for (RoleApplicationRoleAssignment roleApplicationRoleAssignment : privilegeRole.getApplicationRoleAssignments()) {
                Object object;
                String applicationRoleName = roleApplicationRoleAssignment.getApplicationRoleName();
                String applicationName = roleApplicationRoleAssignment.getApplication().getName();
                ApplicationRole applicationRole = (ApplicationRole)applicationRoleMap.get(applicationName + "." + applicationRoleName);
                if (applicationRole != null) {
                    for (PrivilegeGroup privilegeGroup : applicationRole.getPrivilegeGroups()) {
                        object = (ApplicationPrivilegeGroup)groupMap.get(applicationName + "." + privilegeGroup.getName());
                    }
                }
                OrganizationField organizationField = roleApplicationRoleAssignment.getOrganizationFieldFilter();
                OrganizationUnit organizationRoot = roleApplicationRoleAssignment.getFixedOrganizationRoot();
                object = roleApplicationRoleAssignment.getOrganizationUnitTypeFilter();
            }
            for (RolePrivilegeAssignment rolePrivilegeAssignment : privilegeRole.getPrivilegeAssignments()) {
            }
        }
        return null;
    }
}

