/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.ui.address;

import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.Country;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.model.controlcenter.Address;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.NumberField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveFormLayout;

public class AddressForm {
    private final ApplicationInstanceData applicationInstanceData;
    private final TwoWayBindableValue<Address> selectedAddress = TwoWayBindableValue.create();
    private boolean withName;
    private boolean withOrganization;
    private boolean withDependentLocality;
    private boolean withGeoCoordinates;
    private TextField nameField;
    private TextField organizationField;
    private TextField streetField;
    private TextField dependentLocalityField;
    private TextField postalCodeField;
    private TextField cityField;
    private TextField stateField;
    private ComboBox<Country> countryComboBox;
    private NumberField latitudeField;
    private NumberField longitudeField;

    public AddressForm(ApplicationInstanceData applicationInstanceData) {
        this.applicationInstanceData = applicationInstanceData;
        this.init();
    }

    private void init() {
        this.nameField = new TextField();
        this.organizationField = new TextField();
        this.streetField = new TextField();
        this.dependentLocalityField = new TextField();
        this.postalCodeField = new TextField();
        this.cityField = new TextField();
        this.stateField = new TextField();
        this.countryComboBox = Country.createComboBox((ApplicationInstanceData)this.applicationInstanceData);
        this.latitudeField = new NumberField(7);
        this.longitudeField = new NumberField(7);
    }

    public void createAddressSection(ResponsiveFormLayout formLayout) {
        formLayout.addSection(ApplicationIcons.MAP_LOCATION, this.getLocalized("org.teamapps.dictionary.postalAddress"));
    }

    public void addFields(ResponsiveFormLayout formLayout) {
        if (this.withName) {
            formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.name"), "name", (AbstractField)this.nameField);
        }
        if (this.withOrganization) {
            formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.organization"), "organization", (AbstractField)this.organizationField);
        }
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.street"), "street", (AbstractField)this.streetField);
        if (this.withDependentLocality) {
            formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.dependentLocality"), "dependentLocality", (AbstractField)this.dependentLocalityField);
        }
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.postalCode"), "postalCode", (AbstractField)this.postalCodeField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.city"), "city", (AbstractField)this.cityField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.state"), "state", (AbstractField)this.stateField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.country"), "country", this.countryComboBox);
        if (this.withGeoCoordinates) {
            formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.latitude"), "latitude", (AbstractField)this.latitudeField);
            formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.longitude"), "longitude", (AbstractField)this.longitudeField);
        }
    }

    public void setAddress(Address address) {
        if (address == null) {
            address = Address.create();
        }
        this.selectedAddress.set((Object)address);
        this.nameField.setValue((Object)address.getName());
        this.organizationField.setValue((Object)address.getOrganisation());
        this.streetField.setValue((Object)address.getStreet());
        this.cityField.setValue((Object)address.getCity());
        this.dependentLocalityField.setValue((Object)address.getDependentLocality());
        this.stateField.setValue((Object)address.getState());
        this.postalCodeField.setValue((Object)address.getPostalCode());
        this.countryComboBox.setValue((Object)Country.getCountryByIsoCode((String)address.getCountry()));
        this.latitudeField.setValue((Object)Float.valueOf(address.getLatitude()));
        this.longitudeField.setValue((Object)Float.valueOf(address.getLongitude()));
    }

    public boolean validateAddress() {
        return this.countryComboBox.getValue() != null;
    }

    public Address getAddress() {
        Address address = (Address)this.selectedAddress.get();
        address.setName((String)this.nameField.getValue());
        address.setOrganisation((String)this.organizationField.getValue());
        address.setStreet((String)this.streetField.getValue());
        address.setDependentLocality((String)this.dependentLocalityField.getValue());
        address.setPostalCode((String)this.postalCodeField.getValue());
        address.setCity((String)this.cityField.getValue());
        address.setState((String)this.stateField.getValue());
        address.setCountry(this.countryComboBox.getValue() != null ? ((Country)this.countryComboBox.getValue()).getIsoCode() : null);
        address.setLatitude(this.latitudeField.getValue() != null ? ((Number)this.latitudeField.getValue()).floatValue() : 0.0f);
        address.setLongitude(this.longitudeField.getValue() != null ? ((Number)this.longitudeField.getValue()).floatValue() : 0.0f);
        return address;
    }

    private String getLocalized(String key) {
        return this.applicationInstanceData.getLocalized(key, new Object[0]);
    }

    public boolean isWithName() {
        return this.withName;
    }

    public void setWithName(boolean withName) {
        this.withName = withName;
    }

    public boolean isWithOrganization() {
        return this.withOrganization;
    }

    public void setWithOrganization(boolean withOrganization) {
        this.withOrganization = withOrganization;
    }

    public boolean isWithDependentLocality() {
        return this.withDependentLocality;
    }

    public void setWithDependentLocality(boolean withDependentLocality) {
        this.withDependentLocality = withDependentLocality;
    }

    public boolean isWithGeoCoordinates() {
        return this.withGeoCoordinates;
    }

    public void setWithGeoCoordinates(boolean withGeoCoordinates) {
        this.withGeoCoordinates = withGeoCoordinates;
    }

    public TextField getNameField() {
        return this.nameField;
    }

    public TextField getOrganizationField() {
        return this.organizationField;
    }

    public TextField getStreetField() {
        return this.streetField;
    }

    public TextField getDependentLocalityField() {
        return this.dependentLocalityField;
    }

    public TextField getPostalCodeField() {
        return this.postalCodeField;
    }

    public TextField getCityField() {
        return this.cityField;
    }

    public TextField getStateField() {
        return this.stateField;
    }

    public ComboBox<Country> getCountryComboBox() {
        return this.countryComboBox;
    }

    public NumberField getLatitudeField() {
        return this.latitudeField;
    }

    public NumberField getLongitudeField() {
        return this.longitudeField;
    }
}

