package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface Appointment extends Entity<Appointment> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_MESSAGE = "message";
	final static String FIELD_APPOINTMENT_SERIES = "appointmentSeries";
	final static String FIELD_WEB_CONFERENCE = "webConference";
	final static String FIELD_START_DATE_TIME = "startDateTime";
	final static String FIELD_END_DATE_TIME = "endDateTime";
	final static String FIELD_FULL_DAY_EVENT = "fullDayEvent";

    static Appointment create() {
        return new UdbAppointment();
    }

    static Appointment create(int id) {
        return new UdbAppointment(id, true);
    }

    static Appointment getById(int id) {
        return new UdbAppointment(id, false);
    }

    static EntityBuilder<Appointment> getBuilder() {
        return new UdbAppointment(0, false);
    }

    Instant getMetaCreationDate();

    Appointment setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    Appointment setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    Appointment setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    Appointment setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    Appointment setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    Appointment setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    Appointment setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    Appointment setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    Appointment setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    Appointment setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    Appointment setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    Appointment setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    Appointment setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    Appointment setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    Appointment setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    Appointment setMetaRestoredBy(int value);

    Message getMessage();

    Appointment setMessage(Message value);

    AppointmentSeries getAppointmentSeries();

    Appointment setAppointmentSeries(AppointmentSeries value);

    boolean getWebConference();

    Appointment setWebConference(boolean value);

    boolean isWebConference();

    Instant getStartDateTime();

    Appointment setStartDateTime(Instant value);

    long getStartDateTimeAsEpochMilli();

    Appointment setStartDateTimeAsEpochMilli(long value);

    Instant getEndDateTime();

    Appointment setEndDateTime(Instant value);

    long getEndDateTimeAsEpochMilli();

    Appointment setEndDateTimeAsEpochMilli(long value);

    boolean getFullDayEvent();

    Appointment setFullDayEvent(boolean value);

    boolean isFullDayEvent();


    static List<Appointment> getAll() {
        return UdbAppointment.getAll();
    }

    static List<Appointment> getDeletedRecords() {
        return UdbAppointment.getDeletedRecords();
    }

    static List<Appointment> sort(List<Appointment> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbAppointment.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbAppointment.getCount();
    }

    static AppointmentQuery filter() {
        return new UdbAppointmentQuery();
    }
}

