package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface GroupMembershipDefinition extends Entity<GroupMembershipDefinition> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_GROUP_MEMBER_TYPE = "groupMemberType";
	final static String FIELD_USER = "user";
	final static String FIELD_GROUP = "group";
	final static String FIELD_ROLE = "role";
	final static String FIELD_ORGANIZATION_UNIT = "organizationUnit";
	final static String FIELD_ORGANIZATION_UNIT_TYPES_FILTER = "organizationUnitTypesFilter";

    static GroupMembershipDefinition create() {
        return new UdbGroupMembershipDefinition();
    }

    static GroupMembershipDefinition create(int id) {
        return new UdbGroupMembershipDefinition(id, true);
    }

    static GroupMembershipDefinition getById(int id) {
        return new UdbGroupMembershipDefinition(id, false);
    }

    static EntityBuilder<GroupMembershipDefinition> getBuilder() {
        return new UdbGroupMembershipDefinition(0, false);
    }

    Instant getMetaCreationDate();

    GroupMembershipDefinition setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    GroupMembershipDefinition setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    GroupMembershipDefinition setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    GroupMembershipDefinition setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    GroupMembershipDefinition setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    GroupMembershipDefinition setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    GroupMembershipDefinition setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    GroupMembershipDefinition setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    GroupMembershipDefinition setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    GroupMembershipDefinition setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    GroupMembershipDefinition setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    GroupMembershipDefinition setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    GroupMembershipDefinition setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    GroupMembershipDefinition setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    GroupMembershipDefinition setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    GroupMembershipDefinition setMetaRestoredBy(int value);

    GroupMemberType getGroupMemberType();

    GroupMembershipDefinition setGroupMemberType(GroupMemberType value);

    User getUser();

    GroupMembershipDefinition setUser(User value);

    Group getGroup();

    GroupMembershipDefinition setGroup(Group value);

    Role getRole();

    GroupMembershipDefinition setRole(Role value);

    OrganizationUnit getOrganizationUnit();

    GroupMembershipDefinition setOrganizationUnit(OrganizationUnit value);

    List<OrganizationUnitType> getOrganizationUnitTypesFilter();

    GroupMembershipDefinition setOrganizationUnitTypesFilter(List<OrganizationUnitType> value);

    int getOrganizationUnitTypesFilterCount();

    GroupMembershipDefinition setOrganizationUnitTypesFilter(OrganizationUnitType ... value);

    BitSet getOrganizationUnitTypesFilterAsBitSet();

    GroupMembershipDefinition addOrganizationUnitTypesFilter(List<OrganizationUnitType> value);

    GroupMembershipDefinition addOrganizationUnitTypesFilter(OrganizationUnitType ... value);

    GroupMembershipDefinition removeOrganizationUnitTypesFilter(List<OrganizationUnitType> value);

    GroupMembershipDefinition removeOrganizationUnitTypesFilter(OrganizationUnitType ... value);

    GroupMembershipDefinition removeAllOrganizationUnitTypesFilter();


    static List<GroupMembershipDefinition> getAll() {
        return UdbGroupMembershipDefinition.getAll();
    }

    static List<GroupMembershipDefinition> getDeletedRecords() {
        return UdbGroupMembershipDefinition.getDeletedRecords();
    }

    static List<GroupMembershipDefinition> sort(List<GroupMembershipDefinition> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbGroupMembershipDefinition.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbGroupMembershipDefinition.getCount();
    }

    static GroupMembershipDefinitionQuery filter() {
        return new UdbGroupMembershipDefinitionQuery();
    }
}

