package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface LocalizationValue extends Entity<LocalizationValue> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_LOCALIZATION_KEY = "localizationKey";
	final static String FIELD_LANGUAGE = "language";
	final static String FIELD_ORIGINAL = "original";
	final static String FIELD_MACHINE_TRANSLATION = "machineTranslation";
	final static String FIELD_TRANSLATION = "translation";
	final static String FIELD_ADMIN_LOCAL_OVERRIDE = "adminLocalOverride";
	final static String FIELD_ADMIN_KEY_OVERRIDE = "adminKeyOverride";
	final static String FIELD_CURRENT_DISPLAY_VALUE = "currentDisplayValue";
	final static String FIELD_NOTES = "notes";
	final static String FIELD_MACHINE_TRANSLATION_STATE = "machineTranslationState";
	final static String FIELD_TRANSLATION_STATE = "translationState";
	final static String FIELD_TRANSLATION_VERIFICATION_STATE = "translationVerificationState";

    static LocalizationValue create() {
        return new UdbLocalizationValue();
    }

    static LocalizationValue create(int id) {
        return new UdbLocalizationValue(id, true);
    }

    static LocalizationValue getById(int id) {
        return new UdbLocalizationValue(id, false);
    }

    static EntityBuilder<LocalizationValue> getBuilder() {
        return new UdbLocalizationValue(0, false);
    }

    Instant getMetaCreationDate();

    LocalizationValue setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    LocalizationValue setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    LocalizationValue setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    LocalizationValue setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    LocalizationValue setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    LocalizationValue setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    LocalizationValue setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    LocalizationValue setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    LocalizationValue setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    LocalizationValue setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    LocalizationValue setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    LocalizationValue setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    LocalizationValue setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    LocalizationValue setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    LocalizationValue setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    LocalizationValue setMetaRestoredBy(int value);

    LocalizationKey getLocalizationKey();

    LocalizationValue setLocalizationKey(LocalizationKey value);

    String getLanguage();

    LocalizationValue setLanguage(String value);

    String getOriginal();

    LocalizationValue setOriginal(String value);

    String getMachineTranslation();

    LocalizationValue setMachineTranslation(String value);

    String getTranslation();

    LocalizationValue setTranslation(String value);

    String getAdminLocalOverride();

    LocalizationValue setAdminLocalOverride(String value);

    String getAdminKeyOverride();

    LocalizationValue setAdminKeyOverride(String value);

    String getCurrentDisplayValue();

    LocalizationValue setCurrentDisplayValue(String value);

    String getNotes();

    LocalizationValue setNotes(String value);

    MachineTranslationState getMachineTranslationState();

    LocalizationValue setMachineTranslationState(MachineTranslationState value);

    TranslationState getTranslationState();

    LocalizationValue setTranslationState(TranslationState value);

    TranslationVerificationState getTranslationVerificationState();

    LocalizationValue setTranslationVerificationState(TranslationVerificationState value);


    static List<LocalizationValue> getAll() {
        return UdbLocalizationValue.getAll();
    }

    static List<LocalizationValue> getDeletedRecords() {
        return UdbLocalizationValue.getDeletedRecords();
    }

    static List<LocalizationValue> sort(List<LocalizationValue> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbLocalizationValue.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbLocalizationValue.getCount();
    }

    static LocalizationValueQuery filter() {
        return new UdbLocalizationValueQuery();
    }
}

