package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface OrganizationFieldQuery extends Query<OrganizationField> {

    static OrganizationFieldQuery create() {
        return new UdbOrganizationFieldQuery();
    }

    OrganizationFieldQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    OrganizationFieldQuery parseFullTextFilter(String query, String... fieldNames);

	OrganizationFieldQuery metaCreationDate(NumericFilter filter);

	OrganizationFieldQuery orMetaCreationDate(NumericFilter filter);

	OrganizationFieldQuery metaCreatedBy(NumericFilter filter);

	OrganizationFieldQuery orMetaCreatedBy(NumericFilter filter);

	OrganizationFieldQuery metaModificationDate(NumericFilter filter);

	OrganizationFieldQuery orMetaModificationDate(NumericFilter filter);

	OrganizationFieldQuery metaModifiedBy(NumericFilter filter);

	OrganizationFieldQuery orMetaModifiedBy(NumericFilter filter);

	OrganizationFieldQuery metaDeletionDate(NumericFilter filter);

	OrganizationFieldQuery orMetaDeletionDate(NumericFilter filter);

	OrganizationFieldQuery metaDeletedBy(NumericFilter filter);

	OrganizationFieldQuery orMetaDeletedBy(NumericFilter filter);

	OrganizationFieldQuery metaRestoreDate(NumericFilter filter);

	OrganizationFieldQuery orMetaRestoreDate(NumericFilter filter);

	OrganizationFieldQuery metaRestoredBy(NumericFilter filter);

	OrganizationFieldQuery orMetaRestoredBy(NumericFilter filter);

	OrganizationFieldQuery title(TranslatableTextFilter filter);

	OrganizationFieldQuery orTitle(TranslatableTextFilter filter);

	OrganizationFieldQuery icon(TextFilter filter);

	OrganizationFieldQuery orIcon(TextFilter filter);


    OrganizationFieldQuery andOr(OrganizationFieldQuery... queries);

    OrganizationFieldQuery customFilter(Function<OrganizationField, Boolean> customFilter);

    List<OrganizationField> execute();

    List<OrganizationField> executeOnDeletedRecords();

    OrganizationField executeExpectSingleton();

    BitSet executeToBitSet();

    List<OrganizationField> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<OrganizationField> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

