package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbApplicationPrivilegeGroupQuery extends AbstractUdbQuery<ApplicationPrivilegeGroup> implements ApplicationPrivilegeGroupQuery {

    public UdbApplicationPrivilegeGroupQuery() {
        super(UdbApplicationPrivilegeGroup.table, ApplicationPrivilegeGroup.getBuilder());
    }

	@Override
	public ApplicationPrivilegeGroupQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbApplicationPrivilegeGroup.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbApplicationPrivilegeGroup.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery metaCreationDate(NumericFilter filter) {
		and(UdbApplicationPrivilegeGroup.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbApplicationPrivilegeGroup.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery metaCreatedBy(NumericFilter filter) {
		and(UdbApplicationPrivilegeGroup.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbApplicationPrivilegeGroup.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery metaModificationDate(NumericFilter filter) {
		and(UdbApplicationPrivilegeGroup.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbApplicationPrivilegeGroup.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery metaModifiedBy(NumericFilter filter) {
		and(UdbApplicationPrivilegeGroup.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbApplicationPrivilegeGroup.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery metaDeletionDate(NumericFilter filter) {
		and(UdbApplicationPrivilegeGroup.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbApplicationPrivilegeGroup.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery metaDeletedBy(NumericFilter filter) {
		and(UdbApplicationPrivilegeGroup.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbApplicationPrivilegeGroup.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery metaRestoreDate(NumericFilter filter) {
		and(UdbApplicationPrivilegeGroup.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbApplicationPrivilegeGroup.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery metaRestoredBy(NumericFilter filter) {
		and(UdbApplicationPrivilegeGroup.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbApplicationPrivilegeGroup.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery filterApplication(ApplicationQuery query) {
		UdbApplicationQuery udbQuery = (UdbApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationPrivilegeGroup.application, UdbApplication.privilegeGroups);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery application(NumericFilter filter) {
		and(UdbApplicationPrivilegeGroup.application.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orApplication(NumericFilter filter) {
		or(UdbApplicationPrivilegeGroup.application.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery applicationPrivilegeGroupType(EnumFilterType filterType, ApplicationPrivilegeGroupType... enums) {
		and(UdbApplicationPrivilegeGroup.applicationPrivilegeGroupType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orApplicationPrivilegeGroupType(EnumFilterType filterType, ApplicationPrivilegeGroupType... enums) {
		or(UdbApplicationPrivilegeGroup.applicationPrivilegeGroupType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery name(TextFilter filter) {
		and(UdbApplicationPrivilegeGroup.name.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orName(TextFilter filter) {
		or(UdbApplicationPrivilegeGroup.name.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery icon(TextFilter filter) {
		and(UdbApplicationPrivilegeGroup.icon.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orIcon(TextFilter filter) {
		or(UdbApplicationPrivilegeGroup.icon.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery titleKey(TextFilter filter) {
		and(UdbApplicationPrivilegeGroup.titleKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orTitleKey(TextFilter filter) {
		or(UdbApplicationPrivilegeGroup.titleKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery descriptionKey(TextFilter filter) {
		and(UdbApplicationPrivilegeGroup.descriptionKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orDescriptionKey(TextFilter filter) {
		or(UdbApplicationPrivilegeGroup.descriptionKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery filterPrivileges(ApplicationPrivilegeQuery query) {
		UdbApplicationPrivilegeQuery udbQuery = (UdbApplicationPrivilegeQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationPrivilegeGroup.privileges, UdbApplicationPrivilege.privilegeGroup);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery privileges(MultiReferenceFilterType type, ApplicationPrivilege ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (ApplicationPrivilege value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbApplicationPrivilegeGroup.privileges.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery privilegesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbApplicationPrivilegeGroup.privileges.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery privileges(MultiReferenceFilter filter) {
		and(UdbApplicationPrivilegeGroup.privileges.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupQuery orPrivileges(MultiReferenceFilter filter) {
		or(UdbApplicationPrivilegeGroup.privileges.createFilter(filter));
		return this;
	}


	@Override
	public UdbApplicationPrivilegeGroupQuery andOr(ApplicationPrivilegeGroupQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ApplicationPrivilegeGroupQuery customFilter(Function<ApplicationPrivilegeGroup, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(ApplicationPrivilegeGroup.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



