package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbApplicationPrivilegeQuery extends AbstractUdbQuery<ApplicationPrivilege> implements ApplicationPrivilegeQuery {

    public UdbApplicationPrivilegeQuery() {
        super(UdbApplicationPrivilege.table, ApplicationPrivilege.getBuilder());
    }

	@Override
	public ApplicationPrivilegeQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbApplicationPrivilege.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbApplicationPrivilege.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery metaCreationDate(NumericFilter filter) {
		and(UdbApplicationPrivilege.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbApplicationPrivilege.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery metaCreatedBy(NumericFilter filter) {
		and(UdbApplicationPrivilege.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbApplicationPrivilege.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery metaModificationDate(NumericFilter filter) {
		and(UdbApplicationPrivilege.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbApplicationPrivilege.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery metaModifiedBy(NumericFilter filter) {
		and(UdbApplicationPrivilege.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbApplicationPrivilege.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery metaDeletionDate(NumericFilter filter) {
		and(UdbApplicationPrivilege.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbApplicationPrivilege.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery metaDeletedBy(NumericFilter filter) {
		and(UdbApplicationPrivilege.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbApplicationPrivilege.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery metaRestoreDate(NumericFilter filter) {
		and(UdbApplicationPrivilege.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbApplicationPrivilege.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery metaRestoredBy(NumericFilter filter) {
		and(UdbApplicationPrivilege.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbApplicationPrivilege.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery filterPrivilegeGroup(ApplicationPrivilegeGroupQuery query) {
		UdbApplicationPrivilegeGroupQuery udbQuery = (UdbApplicationPrivilegeGroupQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationPrivilege.privilegeGroup, UdbApplicationPrivilegeGroup.privileges);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery privilegeGroup(NumericFilter filter) {
		and(UdbApplicationPrivilege.privilegeGroup.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orPrivilegeGroup(NumericFilter filter) {
		or(UdbApplicationPrivilege.privilegeGroup.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery name(TextFilter filter) {
		and(UdbApplicationPrivilege.name.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orName(TextFilter filter) {
		or(UdbApplicationPrivilege.name.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery icon(TextFilter filter) {
		and(UdbApplicationPrivilege.icon.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orIcon(TextFilter filter) {
		or(UdbApplicationPrivilege.icon.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery titleKey(TextFilter filter) {
		and(UdbApplicationPrivilege.titleKey.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationPrivilegeQuery orTitleKey(TextFilter filter) {
		or(UdbApplicationPrivilege.titleKey.createFilter(filter));
		return this;
	}


	@Override
	public UdbApplicationPrivilegeQuery andOr(ApplicationPrivilegeQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ApplicationPrivilegeQuery customFilter(Function<ApplicationPrivilege, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(ApplicationPrivilege.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



