package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbNewsBoardMessageImage extends AbstractUdbEntity<NewsBoardMessageImage> implements NewsBoardMessageImage {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static FileIndex file;
	protected static FileIndex thumbnail;
	protected static TextIndex fileName;
	protected static BooleanIndex embedded;
	protected static IntegerIndex position;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		file = (FileIndex) tableIndex.getColumnIndex(FIELD_FILE);
		thumbnail = (FileIndex) tableIndex.getColumnIndex(FIELD_THUMBNAIL);
		fileName = (TextIndex) tableIndex.getColumnIndex(FIELD_FILE_NAME);
		embedded = (BooleanIndex) tableIndex.getColumnIndex(FIELD_EMBEDDED);
		position = (IntegerIndex) tableIndex.getColumnIndex(FIELD_POSITION);
    }

    public static List<NewsBoardMessageImage> getAll() {
        return new EntityBitSetList<>(NewsBoardMessageImage.getBuilder(), table.getRecordBitSet());
    }

    public static List<NewsBoardMessageImage> getDeletedRecords() {
        return new EntityBitSetList<>(NewsBoardMessageImage.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<NewsBoardMessageImage> sort(List<NewsBoardMessageImage> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<NewsBoardMessageImage> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, NewsBoardMessageImage.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbNewsBoardMessageImage() {
        super(table);
    }

    public UdbNewsBoardMessageImage(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public NewsBoardMessageImage build() {
        return new UdbNewsBoardMessageImage();
    }

    @Override
    public NewsBoardMessageImage build(int id) {
        return new UdbNewsBoardMessageImage(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public NewsBoardMessageImage setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public NewsBoardMessageImage setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public NewsBoardMessageImage setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public NewsBoardMessageImage setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public NewsBoardMessageImage setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public NewsBoardMessageImage setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public NewsBoardMessageImage setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public NewsBoardMessageImage setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public NewsBoardMessageImage setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public NewsBoardMessageImage setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public NewsBoardMessageImage setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public NewsBoardMessageImage setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public NewsBoardMessageImage setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public NewsBoardMessageImage setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public NewsBoardMessageImage setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public NewsBoardMessageImage setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public FileValue getFile() {
		if (isChanged(file)) {
			return (FileValue) getChangedValue(file);
		} else {
			return file.getValue(getId());
		}
	}

	@Override
	public NewsBoardMessageImage setFile(File value) {
	    FileValue storeFile = file.storeFile(value);
		setChangeValue(this.file, storeFile, table);
		return this;
	}

	@Override
	public NewsBoardMessageImage setFile(File value, String fileName) {
	    FileValue storeFile = file.storeFile(value, fileName);
		setChangeValue(this.file, storeFile, table);
		return this;
	}

	@Override
	public FileValue getThumbnail() {
		if (isChanged(thumbnail)) {
			return (FileValue) getChangedValue(thumbnail);
		} else {
			return thumbnail.getValue(getId());
		}
	}

	@Override
	public NewsBoardMessageImage setThumbnail(File value) {
	    FileValue storeFile = thumbnail.storeFile(value);
		setChangeValue(this.thumbnail, storeFile, table);
		return this;
	}

	@Override
	public NewsBoardMessageImage setThumbnail(File value, String fileName) {
	    FileValue storeFile = thumbnail.storeFile(value, fileName);
		setChangeValue(this.thumbnail, storeFile, table);
		return this;
	}

	@Override
	public String getFileName() {
        return getTextValue(fileName);
	}

	@Override
	public NewsBoardMessageImage setFileName(String value) {
	    setTextValue(value, this.fileName);
		return this;
	}

	@Override
	public boolean getEmbedded() {
	    return getBooleanValue(embedded);
	}

	@Override
	public NewsBoardMessageImage setEmbedded(boolean value) {
	    setBooleanValue(value, this.embedded);
		return this;
	}

	@Override
	public boolean isEmbedded() {
	    return getBooleanValue(embedded);
	}

	@Override
	public int getPosition() {
        return getIntValue(position);
	}

	@Override
	public NewsBoardMessageImage setPosition(int value) {
	    setIntValue(value, this.position);
		return this;
	}


    @Override
    public UdbNewsBoardMessageImage save(Transaction transaction, boolean strictChangeVerification) {
        saveRecord(transaction, strictChangeVerification);
        return this;
    }

    @Override
    public UdbNewsBoardMessageImage saveTransactional(boolean strictChangeVerification) {
        saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    @Override
    public UdbNewsBoardMessageImage save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        deleteRecord(transaction);
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



