package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbOrganizationUnitTypeQuery extends AbstractUdbQuery<OrganizationUnitType> implements OrganizationUnitTypeQuery {

    public UdbOrganizationUnitTypeQuery() {
        super(UdbOrganizationUnitType.table, OrganizationUnitType.getBuilder());
    }

	@Override
	public OrganizationUnitTypeQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbOrganizationUnitType.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbOrganizationUnitType.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery metaCreationDate(NumericFilter filter) {
		and(UdbOrganizationUnitType.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbOrganizationUnitType.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery metaCreatedBy(NumericFilter filter) {
		and(UdbOrganizationUnitType.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbOrganizationUnitType.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery metaModificationDate(NumericFilter filter) {
		and(UdbOrganizationUnitType.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbOrganizationUnitType.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery metaModifiedBy(NumericFilter filter) {
		and(UdbOrganizationUnitType.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbOrganizationUnitType.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery metaDeletionDate(NumericFilter filter) {
		and(UdbOrganizationUnitType.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbOrganizationUnitType.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery metaDeletedBy(NumericFilter filter) {
		and(UdbOrganizationUnitType.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbOrganizationUnitType.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery metaRestoreDate(NumericFilter filter) {
		and(UdbOrganizationUnitType.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbOrganizationUnitType.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery metaRestoredBy(NumericFilter filter) {
		and(UdbOrganizationUnitType.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbOrganizationUnitType.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery name(TranslatableTextFilter filter) {
		and(UdbOrganizationUnitType.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orName(TranslatableTextFilter filter) {
		or(UdbOrganizationUnitType.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery abbreviation(TranslatableTextFilter filter) {
		and(UdbOrganizationUnitType.abbreviation.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orAbbreviation(TranslatableTextFilter filter) {
		or(UdbOrganizationUnitType.abbreviation.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery icon(TextFilter filter) {
		and(UdbOrganizationUnitType.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orIcon(TextFilter filter) {
		or(UdbOrganizationUnitType.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery translateOrganizationUnits(BooleanFilter filter) {
		and(UdbOrganizationUnitType.translateOrganizationUnits.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orTranslateOrganizationUnits(BooleanFilter filter) {
		or(UdbOrganizationUnitType.translateOrganizationUnits.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery allowUsers(BooleanFilter filter) {
		and(UdbOrganizationUnitType.allowUsers.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orAllowUsers(BooleanFilter filter) {
		or(UdbOrganizationUnitType.allowUsers.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery filterDefaultChildType(OrganizationUnitTypeQuery query) {
		UdbOrganizationUnitTypeQuery udbQuery = (UdbOrganizationUnitTypeQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitType.defaultChildType);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery defaultChildType(NumericFilter filter) {
		and(UdbOrganizationUnitType.defaultChildType.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orDefaultChildType(NumericFilter filter) {
		or(UdbOrganizationUnitType.defaultChildType.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery filterPossibleChildrenTypes(OrganizationUnitTypeQuery query) {
		UdbOrganizationUnitTypeQuery udbQuery = (UdbOrganizationUnitTypeQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitType.possibleChildrenTypes);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery possibleChildrenTypes(MultiReferenceFilterType type, OrganizationUnitType ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (OrganizationUnitType value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbOrganizationUnitType.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery possibleChildrenTypesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbOrganizationUnitType.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery possibleChildrenTypes(MultiReferenceFilter filter) {
		and(UdbOrganizationUnitType.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orPossibleChildrenTypes(MultiReferenceFilter filter) {
		or(UdbOrganizationUnitType.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery geoLocationType(EnumFilterType filterType, GeoLocationType... enums) {
		and(UdbOrganizationUnitType.geoLocationType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public OrganizationUnitTypeQuery orGeoLocationType(EnumFilterType filterType, GeoLocationType... enums) {
		or(UdbOrganizationUnitType.geoLocationType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}


	@Override
	public UdbOrganizationUnitTypeQuery andOr(OrganizationUnitTypeQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public OrganizationUnitTypeQuery customFilter(Function<OrganizationUnitType, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(OrganizationUnitType.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



