package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbRoleApplicationRoleAssignmentQuery extends AbstractUdbQuery<RoleApplicationRoleAssignment> implements RoleApplicationRoleAssignmentQuery {

    public UdbRoleApplicationRoleAssignmentQuery() {
        super(UdbRoleApplicationRoleAssignment.table, RoleApplicationRoleAssignment.getBuilder());
    }

	@Override
	public RoleApplicationRoleAssignmentQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbRoleApplicationRoleAssignment.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbRoleApplicationRoleAssignment.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery metaCreationDate(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery metaCreatedBy(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery metaModificationDate(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery metaModifiedBy(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery metaDeletionDate(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery metaDeletedBy(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery metaRestoreDate(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery metaRestoredBy(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery filterRole(RoleQuery query) {
		UdbRoleQuery udbQuery = (UdbRoleQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRoleApplicationRoleAssignment.role, UdbRole.applicationRoleAssignments);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery role(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.role.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orRole(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.role.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery filterApplication(ApplicationQuery query) {
		UdbApplicationQuery udbQuery = (UdbApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRoleApplicationRoleAssignment.application);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery application(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.application.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orApplication(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.application.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery applicationRoleName(TextFilter filter) {
		and(UdbRoleApplicationRoleAssignment.applicationRoleName.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orApplicationRoleName(TextFilter filter) {
		or(UdbRoleApplicationRoleAssignment.applicationRoleName.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery filterOrganizationFieldFilter(OrganizationFieldQuery query) {
		UdbOrganizationFieldQuery udbQuery = (UdbOrganizationFieldQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRoleApplicationRoleAssignment.organizationFieldFilter);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery organizationFieldFilter(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.organizationFieldFilter.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orOrganizationFieldFilter(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.organizationFieldFilter.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery filterFixedOrganizationRoot(OrganizationUnitQuery query) {
		UdbOrganizationUnitQuery udbQuery = (UdbOrganizationUnitQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRoleApplicationRoleAssignment.fixedOrganizationRoot);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery fixedOrganizationRoot(NumericFilter filter) {
		and(UdbRoleApplicationRoleAssignment.fixedOrganizationRoot.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orFixedOrganizationRoot(NumericFilter filter) {
		or(UdbRoleApplicationRoleAssignment.fixedOrganizationRoot.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery filterOrganizationUnitTypeFilter(OrganizationUnitTypeQuery query) {
		UdbOrganizationUnitTypeQuery udbQuery = (UdbOrganizationUnitTypeQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbRoleApplicationRoleAssignment.organizationUnitTypeFilter);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery organizationUnitTypeFilter(MultiReferenceFilterType type, OrganizationUnitType ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (OrganizationUnitType value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbRoleApplicationRoleAssignment.organizationUnitTypeFilter.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery organizationUnitTypeFilterCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbRoleApplicationRoleAssignment.organizationUnitTypeFilter.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery organizationUnitTypeFilter(MultiReferenceFilter filter) {
		and(UdbRoleApplicationRoleAssignment.organizationUnitTypeFilter.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orOrganizationUnitTypeFilter(MultiReferenceFilter filter) {
		or(UdbRoleApplicationRoleAssignment.organizationUnitTypeFilter.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery noInheritanceOfOrganizationalUnits(BooleanFilter filter) {
		and(UdbRoleApplicationRoleAssignment.noInheritanceOfOrganizationalUnits.createFilter(filter));
		return this;
	}

	@Override
	public RoleApplicationRoleAssignmentQuery orNoInheritanceOfOrganizationalUnits(BooleanFilter filter) {
		or(UdbRoleApplicationRoleAssignment.noInheritanceOfOrganizationalUnits.createFilter(filter));
		return this;
	}


	@Override
	public UdbRoleApplicationRoleAssignmentQuery andOr(RoleApplicationRoleAssignmentQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public RoleApplicationRoleAssignmentQuery customFilter(Function<RoleApplicationRoleAssignment, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(RoleApplicationRoleAssignment.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



