package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbUserAccessTokenQuery extends AbstractUdbQuery<UserAccessToken> implements UserAccessTokenQuery {

    public UdbUserAccessTokenQuery() {
        super(UdbUserAccessToken.table, UserAccessToken.getBuilder());
    }

	@Override
	public UserAccessTokenQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbUserAccessToken.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public UserAccessTokenQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbUserAccessToken.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public UserAccessTokenQuery metaCreationDate(NumericFilter filter) {
		and(UdbUserAccessToken.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbUserAccessToken.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery metaCreatedBy(NumericFilter filter) {
		and(UdbUserAccessToken.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbUserAccessToken.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery metaDeletionDate(NumericFilter filter) {
		and(UdbUserAccessToken.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbUserAccessToken.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery metaDeletedBy(NumericFilter filter) {
		and(UdbUserAccessToken.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbUserAccessToken.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery metaRestoreDate(NumericFilter filter) {
		and(UdbUserAccessToken.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbUserAccessToken.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery metaRestoredBy(NumericFilter filter) {
		and(UdbUserAccessToken.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbUserAccessToken.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery filterUser(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserAccessToken.user, UdbUser.accessTokens);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserAccessTokenQuery user(NumericFilter filter) {
		and(UdbUserAccessToken.user.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orUser(NumericFilter filter) {
		or(UdbUserAccessToken.user.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery userAgentOnCreation(TextFilter filter) {
		and(UdbUserAccessToken.userAgentOnCreation.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orUserAgentOnCreation(TextFilter filter) {
		or(UdbUserAccessToken.userAgentOnCreation.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery userAgentLastUsed(TextFilter filter) {
		and(UdbUserAccessToken.userAgentLastUsed.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orUserAgentLastUsed(TextFilter filter) {
		or(UdbUserAccessToken.userAgentLastUsed.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery lastUsed(NumericFilter filter) {
		and(UdbUserAccessToken.lastUsed.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orLastUsed(NumericFilter filter) {
		or(UdbUserAccessToken.lastUsed.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery valid(BooleanFilter filter) {
		and(UdbUserAccessToken.valid.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orValid(BooleanFilter filter) {
		or(UdbUserAccessToken.valid.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery restApi(BooleanFilter filter) {
		and(UdbUserAccessToken.restApi.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orRestApi(BooleanFilter filter) {
		or(UdbUserAccessToken.restApi.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery secureToken(TextFilter filter) {
		and(UdbUserAccessToken.secureToken.createFilter(filter));
		return this;
	}

	@Override
	public UserAccessTokenQuery orSecureToken(TextFilter filter) {
		or(UdbUserAccessToken.secureToken.createFilter(filter));
		return this;
	}


	@Override
	public UdbUserAccessTokenQuery andOr(UserAccessTokenQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public UserAccessTokenQuery customFilter(Function<UserAccessToken, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(UserAccessToken.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



