package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface UserRoleAssignmentQuery extends Query<UserRoleAssignment> {

    static UserRoleAssignmentQuery create() {
        return new UdbUserRoleAssignmentQuery();
    }

    UserRoleAssignmentQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    UserRoleAssignmentQuery parseFullTextFilter(String query, String... fieldNames);

	UserRoleAssignmentQuery metaCreationDate(NumericFilter filter);

	UserRoleAssignmentQuery orMetaCreationDate(NumericFilter filter);

	UserRoleAssignmentQuery metaCreatedBy(NumericFilter filter);

	UserRoleAssignmentQuery orMetaCreatedBy(NumericFilter filter);

	UserRoleAssignmentQuery metaModificationDate(NumericFilter filter);

	UserRoleAssignmentQuery orMetaModificationDate(NumericFilter filter);

	UserRoleAssignmentQuery metaModifiedBy(NumericFilter filter);

	UserRoleAssignmentQuery orMetaModifiedBy(NumericFilter filter);

	UserRoleAssignmentQuery metaDeletionDate(NumericFilter filter);

	UserRoleAssignmentQuery orMetaDeletionDate(NumericFilter filter);

	UserRoleAssignmentQuery metaDeletedBy(NumericFilter filter);

	UserRoleAssignmentQuery orMetaDeletedBy(NumericFilter filter);

	UserRoleAssignmentQuery metaRestoreDate(NumericFilter filter);

	UserRoleAssignmentQuery orMetaRestoreDate(NumericFilter filter);

	UserRoleAssignmentQuery metaRestoredBy(NumericFilter filter);

	UserRoleAssignmentQuery orMetaRestoredBy(NumericFilter filter);

	UserRoleAssignmentQuery filterUser(UserQuery query);

	UserRoleAssignmentQuery user(NumericFilter filter);

	UserRoleAssignmentQuery orUser(NumericFilter filter);

	UserRoleAssignmentQuery filterRole(RoleQuery query);

	UserRoleAssignmentQuery role(NumericFilter filter);

	UserRoleAssignmentQuery orRole(NumericFilter filter);

	UserRoleAssignmentQuery filterOrganizationUnit(OrganizationUnitQuery query);

	UserRoleAssignmentQuery organizationUnit(NumericFilter filter);

	UserRoleAssignmentQuery orOrganizationUnit(NumericFilter filter);

	UserRoleAssignmentQuery mainResponsible(BooleanFilter filter);

	UserRoleAssignmentQuery orMainResponsible(BooleanFilter filter);

	UserRoleAssignmentQuery lastVerified(NumericFilter filter);

	UserRoleAssignmentQuery orLastVerified(NumericFilter filter);

	UserRoleAssignmentQuery filterLastVerifiedBy(UserQuery query);

	UserRoleAssignmentQuery lastVerifiedBy(NumericFilter filter);

	UserRoleAssignmentQuery orLastVerifiedBy(NumericFilter filter);


    UserRoleAssignmentQuery andOr(UserRoleAssignmentQuery... queries);

    UserRoleAssignmentQuery customFilter(Function<UserRoleAssignment, Boolean> customFilter);

    List<UserRoleAssignment> execute();

    List<UserRoleAssignment> executeOnDeletedRecords();

    UserRoleAssignment executeExpectSingleton();

    BitSet executeToBitSet();

    List<UserRoleAssignment> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<UserRoleAssignment> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

