/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.organization;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.application.server.controlcenter.organization.OrgChartNode;
import org.teamapps.model.controlcenter.RoleType;

public class OrgChartRow {
    private final OrgChartNode orgUnitNode;
    private final OrgChartNode leaderNode;
    private final OrgChartNode assistantNode;
    private final OrgChartNode otherNode;

    public static List<OrgChartRow> createRows(OrgChartNode orgChartNode) {
        ArrayList<OrgChartRow> rows = new ArrayList<OrgChartRow>();
        List<OrgChartNode> leaderNodes = orgChartNode.getNodesByType(RoleType.LEADER);
        List<OrgChartNode> assistantNodes = orgChartNode.getNodesByType(RoleType.MENTOR, RoleType.ASSISTANT, RoleType.ADMINISTRATOR);
        List<OrgChartNode> otherNodes = orgChartNode.getNodesByType(RoleType.OTHER);
        int rowsCount = Math.max(1, Math.max(leaderNodes.size(), Math.max(assistantNodes.size(), otherNodes.size())));
        for (int i = 0; i < rowsCount; ++i) {
            OrgChartNode orgUnitNode = i == 0 ? orgChartNode : null;
            OrgChartNode leaderNode = leaderNodes.size() > i ? leaderNodes.get(i) : null;
            OrgChartNode assistantNode = assistantNodes.size() > i ? assistantNodes.get(i) : null;
            OrgChartNode otherNode = otherNodes.size() > i ? otherNodes.get(i) : null;
            rows.add(new OrgChartRow(orgUnitNode, leaderNode, assistantNode, otherNode));
        }
        return rows;
    }

    public OrgChartRow(OrgChartNode orgUnitNode, OrgChartNode leaderNode, OrgChartNode assistantNode, OrgChartNode otherNode) {
        this.orgUnitNode = orgUnitNode;
        this.leaderNode = leaderNode;
        this.assistantNode = assistantNode;
        this.otherNode = otherNode;
    }

    public boolean match(String query) {
        if (this.orgUnitNode != null && this.orgUnitNode.matches(query)) {
            return true;
        }
        if (this.leaderNode != null && this.leaderNode.matches(query)) {
            return true;
        }
        if (this.assistantNode != null && this.assistantNode.matches(query)) {
            return true;
        }
        return this.otherNode != null && this.otherNode.matches(query);
    }

    public OrgChartNode getOrgUnitNode() {
        return this.orgUnitNode;
    }

    public OrgChartNode getLeaderNode() {
        return this.leaderNode;
    }

    public OrgChartNode getAssistantNode() {
        return this.assistantNode;
    }

    public OrgChartNode getOtherNode() {
        return this.otherNode;
    }
}

