/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.localization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.application.server.system.localization.LocalizationProvider;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationKeyType;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.numeric.NumericFilter;

public class SystemLocalizationProvider
implements LocalizationProvider {
    public static final String SYSTEM_KEY_PREFIX = "org.teamapps.systemKey.";
    private Map<String, Map<String, LocalizationValue>> localizationLanguageValueMapByKey;

    public SystemLocalizationProvider() {
        this.update();
    }

    public void update() {
        HashMap<String, Map<String, LocalizationValue>> localizationLanguageValueMapByKey = new HashMap<String, Map<String, LocalizationValue>>();
        LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)0)).localizationKeyType(EnumFilterType.EQUALS, LocalizationKeyType.SYSTEM_KEY).execute().stream().flatMap(key -> key.getLocalizationValues().stream()).forEach(value -> localizationLanguageValueMapByKey.computeIfAbsent(value.getLocalizationKey().getKey(), k -> new HashMap()).put(value.getLanguage(), value));
        this.localizationLanguageValueMapByKey = localizationLanguageValueMapByKey;
    }

    public void reload() {
        this.update();
    }

    @Deprecated
    public void createKey(String key, String language, String value) {
        if (!((String)key).startsWith(SYSTEM_KEY_PREFIX)) {
            key = SYSTEM_KEY_PREFIX + (String)key;
        }
        LocalizationKey localizationKey = (LocalizationKey)LocalizationKey.create().setKey((String)key).setLocalizationKeyType(LocalizationKeyType.SYSTEM_KEY).setUsed(true).save();
        LocalizationValue localizationValue = (LocalizationValue)LocalizationValue.create().setLocalizationKey(localizationKey).setLanguage(language).setOriginal(value).save();
        this.localizationLanguageValueMapByKey.computeIfAbsent(localizationKey.getKey(), k -> new HashMap()).put(localizationValue.getLanguage(), localizationValue);
    }

    @Override
    public String getLocalizationValue(String key, List<String> languagePriorityOrder) {
        Map<String, LocalizationValue> languageValueMap = this.localizationLanguageValueMapByKey.get(key);
        if (languageValueMap != null) {
            for (String language : languagePriorityOrder) {
                LocalizationValue value = languageValueMap.get(language);
                if (value == null || value.getCurrentDisplayValue() == null) continue;
                return value.getCurrentDisplayValue();
            }
        }
        return key;
    }
}

