package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface AddressQuery extends Query<Address> {

    static AddressQuery create() {
        return new UdbAddressQuery();
    }

    AddressQuery id(Integer... ids);

    AddressQuery id(BitSet ids);

    AddressQuery id(Collection<Integer> ids);

    AddressQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    AddressQuery parseFullTextFilter(String query, String... fieldNames);

	AddressQuery metaCreationDate(NumericFilter filter);

	AddressQuery orMetaCreationDate(NumericFilter filter);

	AddressQuery metaCreatedBy(NumericFilter filter);

	AddressQuery orMetaCreatedBy(NumericFilter filter);

	AddressQuery metaModificationDate(NumericFilter filter);

	AddressQuery orMetaModificationDate(NumericFilter filter);

	AddressQuery metaModifiedBy(NumericFilter filter);

	AddressQuery orMetaModifiedBy(NumericFilter filter);

	AddressQuery metaDeletionDate(NumericFilter filter);

	AddressQuery orMetaDeletionDate(NumericFilter filter);

	AddressQuery metaDeletedBy(NumericFilter filter);

	AddressQuery orMetaDeletedBy(NumericFilter filter);

	AddressQuery metaRestoreDate(NumericFilter filter);

	AddressQuery orMetaRestoreDate(NumericFilter filter);

	AddressQuery metaRestoredBy(NumericFilter filter);

	AddressQuery orMetaRestoredBy(NumericFilter filter);

	AddressQuery name(TextFilter filter);

	AddressQuery orName(TextFilter filter);

	AddressQuery organisation(TextFilter filter);

	AddressQuery orOrganisation(TextFilter filter);

	AddressQuery street(TextFilter filter);

	AddressQuery orStreet(TextFilter filter);

	AddressQuery city(TextFilter filter);

	AddressQuery orCity(TextFilter filter);

	AddressQuery dependentLocality(TextFilter filter);

	AddressQuery orDependentLocality(TextFilter filter);

	AddressQuery state(TextFilter filter);

	AddressQuery orState(TextFilter filter);

	AddressQuery postalCode(TextFilter filter);

	AddressQuery orPostalCode(TextFilter filter);

	AddressQuery country(TextFilter filter);

	AddressQuery orCountry(TextFilter filter);

	AddressQuery latitude(NumericFilter filter);

	AddressQuery orLatitude(NumericFilter filter);

	AddressQuery longitude(NumericFilter filter);

	AddressQuery orLongitude(NumericFilter filter);


    AddressQuery andOr(AddressQuery... queries);

    AddressQuery customFilter(Function<Address, Boolean> customFilter);

    List<Address> execute();

    List<Address> executeOnDeletedRecords();

    Address executeExpectSingleton();

    BitSet executeToBitSet();

    List<Address> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<Address> execute(boolean deletedRecords, String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<Address> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

