package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface AppointmentQuery extends Query<Appointment> {

    static AppointmentQuery create() {
        return new UdbAppointmentQuery();
    }

    AppointmentQuery id(Integer... ids);

    AppointmentQuery id(BitSet ids);

    AppointmentQuery id(Collection<Integer> ids);

    AppointmentQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    AppointmentQuery parseFullTextFilter(String query, String... fieldNames);

	AppointmentQuery metaCreationDate(NumericFilter filter);

	AppointmentQuery orMetaCreationDate(NumericFilter filter);

	AppointmentQuery metaCreatedBy(NumericFilter filter);

	AppointmentQuery orMetaCreatedBy(NumericFilter filter);

	AppointmentQuery metaModificationDate(NumericFilter filter);

	AppointmentQuery orMetaModificationDate(NumericFilter filter);

	AppointmentQuery metaModifiedBy(NumericFilter filter);

	AppointmentQuery orMetaModifiedBy(NumericFilter filter);

	AppointmentQuery metaDeletionDate(NumericFilter filter);

	AppointmentQuery orMetaDeletionDate(NumericFilter filter);

	AppointmentQuery metaDeletedBy(NumericFilter filter);

	AppointmentQuery orMetaDeletedBy(NumericFilter filter);

	AppointmentQuery metaRestoreDate(NumericFilter filter);

	AppointmentQuery orMetaRestoreDate(NumericFilter filter);

	AppointmentQuery metaRestoredBy(NumericFilter filter);

	AppointmentQuery orMetaRestoredBy(NumericFilter filter);

	AppointmentQuery filterMessage(MessageQuery query);

	AppointmentQuery message(NumericFilter filter);

	AppointmentQuery orMessage(NumericFilter filter);

	AppointmentQuery filterAppointmentSeries(AppointmentSeriesQuery query);

	AppointmentQuery appointmentSeries(NumericFilter filter);

	AppointmentQuery orAppointmentSeries(NumericFilter filter);

	AppointmentQuery webConference(BooleanFilter filter);

	AppointmentQuery orWebConference(BooleanFilter filter);

	AppointmentQuery startDateTime(NumericFilter filter);

	AppointmentQuery orStartDateTime(NumericFilter filter);

	AppointmentQuery endDateTime(NumericFilter filter);

	AppointmentQuery orEndDateTime(NumericFilter filter);

	AppointmentQuery fullDayEvent(BooleanFilter filter);

	AppointmentQuery orFullDayEvent(BooleanFilter filter);


    AppointmentQuery andOr(AppointmentQuery... queries);

    AppointmentQuery customFilter(Function<Appointment, Boolean> customFilter);

    List<Appointment> execute();

    List<Appointment> executeOnDeletedRecords();

    Appointment executeExpectSingleton();

    BitSet executeToBitSet();

    List<Appointment> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<Appointment> execute(boolean deletedRecords, String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<Appointment> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

