package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface ChatChannelQuery extends Query<ChatChannel> {

    static ChatChannelQuery create() {
        return new UdbChatChannelQuery();
    }

    ChatChannelQuery id(Integer... ids);

    ChatChannelQuery id(BitSet ids);

    ChatChannelQuery id(Collection<Integer> ids);

    ChatChannelQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ChatChannelQuery parseFullTextFilter(String query, String... fieldNames);

	ChatChannelQuery metaCreationDate(NumericFilter filter);

	ChatChannelQuery orMetaCreationDate(NumericFilter filter);

	ChatChannelQuery metaCreatedBy(NumericFilter filter);

	ChatChannelQuery orMetaCreatedBy(NumericFilter filter);

	ChatChannelQuery metaModificationDate(NumericFilter filter);

	ChatChannelQuery orMetaModificationDate(NumericFilter filter);

	ChatChannelQuery metaModifiedBy(NumericFilter filter);

	ChatChannelQuery orMetaModifiedBy(NumericFilter filter);

	ChatChannelQuery metaDeletionDate(NumericFilter filter);

	ChatChannelQuery orMetaDeletionDate(NumericFilter filter);

	ChatChannelQuery metaDeletedBy(NumericFilter filter);

	ChatChannelQuery orMetaDeletedBy(NumericFilter filter);

	ChatChannelQuery metaRestoreDate(NumericFilter filter);

	ChatChannelQuery orMetaRestoreDate(NumericFilter filter);

	ChatChannelQuery metaRestoredBy(NumericFilter filter);

	ChatChannelQuery orMetaRestoredBy(NumericFilter filter);

	ChatChannelQuery title(TextFilter filter);

	ChatChannelQuery orTitle(TextFilter filter);

	ChatChannelQuery filterChatMessages(ChatMessageQuery query);

	ChatChannelQuery chatMessages(MultiReferenceFilterType type, ChatMessage ... value);

	ChatChannelQuery chatMessagesCount(MultiReferenceFilterType type, int count);

	ChatChannelQuery chatMessages(MultiReferenceFilter filter);

	ChatChannelQuery orChatMessages(MultiReferenceFilter filter);


    ChatChannelQuery andOr(ChatChannelQuery... queries);

    ChatChannelQuery customFilter(Function<ChatChannel, Boolean> customFilter);

    List<ChatChannel> execute();

    List<ChatChannel> executeOnDeletedRecords();

    ChatChannel executeExpectSingleton();

    BitSet executeToBitSet();

    List<ChatChannel> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<ChatChannel> execute(boolean deletedRecords, String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<ChatChannel> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

