package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface RoleQuery extends Query<Role> {

    static RoleQuery create() {
        return new UdbRoleQuery();
    }

    RoleQuery id(Integer... ids);

    RoleQuery id(BitSet ids);

    RoleQuery id(Collection<Integer> ids);

    RoleQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    RoleQuery parseFullTextFilter(String query, String... fieldNames);

	RoleQuery metaCreationDate(NumericFilter filter);

	RoleQuery orMetaCreationDate(NumericFilter filter);

	RoleQuery metaCreatedBy(NumericFilter filter);

	RoleQuery orMetaCreatedBy(NumericFilter filter);

	RoleQuery metaModificationDate(NumericFilter filter);

	RoleQuery orMetaModificationDate(NumericFilter filter);

	RoleQuery metaModifiedBy(NumericFilter filter);

	RoleQuery orMetaModifiedBy(NumericFilter filter);

	RoleQuery metaDeletionDate(NumericFilter filter);

	RoleQuery orMetaDeletionDate(NumericFilter filter);

	RoleQuery metaDeletedBy(NumericFilter filter);

	RoleQuery orMetaDeletedBy(NumericFilter filter);

	RoleQuery metaRestoreDate(NumericFilter filter);

	RoleQuery orMetaRestoreDate(NumericFilter filter);

	RoleQuery metaRestoredBy(NumericFilter filter);

	RoleQuery orMetaRestoredBy(NumericFilter filter);

	RoleQuery title(TranslatableTextFilter filter);

	RoleQuery orTitle(TranslatableTextFilter filter);

	RoleQuery icon(TextFilter filter);

	RoleQuery orIcon(TextFilter filter);

	RoleQuery roleType(EnumFilterType filterType, RoleType ... enums);

	RoleQuery orRoleType(EnumFilterType filterType, RoleType ... enums);

	RoleQuery filterParent(RoleQuery query);

	RoleQuery parent(NumericFilter filter);

	RoleQuery orParent(NumericFilter filter);

	RoleQuery filterChildren(RoleQuery query);

	RoleQuery children(MultiReferenceFilterType type, Role ... value);

	RoleQuery childrenCount(MultiReferenceFilterType type, int count);

	RoleQuery children(MultiReferenceFilter filter);

	RoleQuery orChildren(MultiReferenceFilter filter);

	RoleQuery filterOrganizationUnit(OrganizationUnitQuery query);

	RoleQuery organizationUnit(NumericFilter filter);

	RoleQuery orOrganizationUnit(NumericFilter filter);

	RoleQuery filterAllowedOrganizationUnitTypes(OrganizationUnitTypeQuery query);

	RoleQuery allowedOrganizationUnitTypes(MultiReferenceFilterType type, OrganizationUnitType ... value);

	RoleQuery allowedOrganizationUnitTypesCount(MultiReferenceFilterType type, int count);

	RoleQuery allowedOrganizationUnitTypes(MultiReferenceFilter filter);

	RoleQuery orAllowedOrganizationUnitTypes(MultiReferenceFilter filter);

	RoleQuery filterOrganizationField(OrganizationFieldQuery query);

	RoleQuery organizationField(NumericFilter filter);

	RoleQuery orOrganizationField(NumericFilter filter);

	RoleQuery delegatedCustomPrivilegeObjectRole(BooleanFilter filter);

	RoleQuery orDelegatedCustomPrivilegeObjectRole(BooleanFilter filter);

	RoleQuery filterGeneralizationRoles(RoleQuery query);

	RoleQuery generalizationRoles(MultiReferenceFilterType type, Role ... value);

	RoleQuery generalizationRolesCount(MultiReferenceFilterType type, int count);

	RoleQuery generalizationRoles(MultiReferenceFilter filter);

	RoleQuery orGeneralizationRoles(MultiReferenceFilter filter);

	RoleQuery filterSpecializationRoles(RoleQuery query);

	RoleQuery specializationRoles(MultiReferenceFilterType type, Role ... value);

	RoleQuery specializationRolesCount(MultiReferenceFilterType type, int count);

	RoleQuery specializationRoles(MultiReferenceFilter filter);

	RoleQuery orSpecializationRoles(MultiReferenceFilter filter);

	RoleQuery filterPrivilegesReceivingRoles(RoleQuery query);

	RoleQuery privilegesReceivingRoles(MultiReferenceFilterType type, Role ... value);

	RoleQuery privilegesReceivingRolesCount(MultiReferenceFilterType type, int count);

	RoleQuery privilegesReceivingRoles(MultiReferenceFilter filter);

	RoleQuery orPrivilegesReceivingRoles(MultiReferenceFilter filter);

	RoleQuery filterPrivilegesSendingRoles(RoleQuery query);

	RoleQuery privilegesSendingRoles(MultiReferenceFilterType type, Role ... value);

	RoleQuery privilegesSendingRolesCount(MultiReferenceFilterType type, int count);

	RoleQuery privilegesSendingRoles(MultiReferenceFilter filter);

	RoleQuery orPrivilegesSendingRoles(MultiReferenceFilter filter);

	RoleQuery noDirectMemberships(BooleanFilter filter);

	RoleQuery orNoDirectMemberships(BooleanFilter filter);

	RoleQuery filterUserRoleAssignments(UserRoleAssignmentQuery query);

	RoleQuery userRoleAssignments(MultiReferenceFilterType type, UserRoleAssignment ... value);

	RoleQuery userRoleAssignmentsCount(MultiReferenceFilterType type, int count);

	RoleQuery userRoleAssignments(MultiReferenceFilter filter);

	RoleQuery orUserRoleAssignments(MultiReferenceFilter filter);

	RoleQuery filterPrivilegeAssignments(RolePrivilegeAssignmentQuery query);

	RoleQuery privilegeAssignments(MultiReferenceFilterType type, RolePrivilegeAssignment ... value);

	RoleQuery privilegeAssignmentsCount(MultiReferenceFilterType type, int count);

	RoleQuery privilegeAssignments(MultiReferenceFilter filter);

	RoleQuery orPrivilegeAssignments(MultiReferenceFilter filter);

	RoleQuery filterApplicationRoleAssignments(RoleApplicationRoleAssignmentQuery query);

	RoleQuery applicationRoleAssignments(MultiReferenceFilterType type, RoleApplicationRoleAssignment ... value);

	RoleQuery applicationRoleAssignmentsCount(MultiReferenceFilterType type, int count);

	RoleQuery applicationRoleAssignments(MultiReferenceFilter filter);

	RoleQuery orApplicationRoleAssignments(MultiReferenceFilter filter);


    RoleQuery andOr(RoleQuery... queries);

    RoleQuery customFilter(Function<Role, Boolean> customFilter);

    List<Role> execute();

    List<Role> executeOnDeletedRecords();

    Role executeExpectSingleton();

    BitSet executeToBitSet();

    List<Role> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<Role> execute(boolean deletedRecords, String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<Role> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

