package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbAddress extends AbstractUdbEntity<Address> implements Address {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static TextIndex name;
	protected static TextIndex organisation;
	protected static TextIndex street;
	protected static TextIndex city;
	protected static TextIndex dependentLocality;
	protected static TextIndex state;
	protected static TextIndex postalCode;
	protected static TextIndex country;
	protected static FloatIndex latitude;
	protected static FloatIndex longitude;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		name = (TextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		organisation = (TextIndex) tableIndex.getColumnIndex(FIELD_ORGANISATION);
		street = (TextIndex) tableIndex.getColumnIndex(FIELD_STREET);
		city = (TextIndex) tableIndex.getColumnIndex(FIELD_CITY);
		dependentLocality = (TextIndex) tableIndex.getColumnIndex(FIELD_DEPENDENT_LOCALITY);
		state = (TextIndex) tableIndex.getColumnIndex(FIELD_STATE);
		postalCode = (TextIndex) tableIndex.getColumnIndex(FIELD_POSTAL_CODE);
		country = (TextIndex) tableIndex.getColumnIndex(FIELD_COUNTRY);
		latitude = (FloatIndex) tableIndex.getColumnIndex(FIELD_LATITUDE);
		longitude = (FloatIndex) tableIndex.getColumnIndex(FIELD_LONGITUDE);
    }

    public static List<Address> getAll() {
        return new EntityBitSetList<>(Address.getBuilder(), table.getRecordBitSet());
    }

    public static List<Address> getDeletedRecords() {
        return new EntityBitSetList<>(Address.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<Address> sort(List<Address> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<Address> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, Address.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbAddress() {
        super(table);
    }

    public UdbAddress(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public Address build() {
        return new UdbAddress();
    }

    @Override
    public Address build(int id) {
        return new UdbAddress(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public Address setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public Address setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public Address setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public Address setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public Address setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public Address setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public Address setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public Address setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public Address setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public Address setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public Address setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public Address setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public Address setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public Address setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public Address setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public Address setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public String getName() {
        return getTextValue(name);
	}

	@Override
	public Address setName(String value) {
	    setTextValue(value, this.name);
		return this;
	}

	@Override
	public String getOrganisation() {
        return getTextValue(organisation);
	}

	@Override
	public Address setOrganisation(String value) {
	    setTextValue(value, this.organisation);
		return this;
	}

	@Override
	public String getStreet() {
        return getTextValue(street);
	}

	@Override
	public Address setStreet(String value) {
	    setTextValue(value, this.street);
		return this;
	}

	@Override
	public String getCity() {
        return getTextValue(city);
	}

	@Override
	public Address setCity(String value) {
	    setTextValue(value, this.city);
		return this;
	}

	@Override
	public String getDependentLocality() {
        return getTextValue(dependentLocality);
	}

	@Override
	public Address setDependentLocality(String value) {
	    setTextValue(value, this.dependentLocality);
		return this;
	}

	@Override
	public String getState() {
        return getTextValue(state);
	}

	@Override
	public Address setState(String value) {
	    setTextValue(value, this.state);
		return this;
	}

	@Override
	public String getPostalCode() {
        return getTextValue(postalCode);
	}

	@Override
	public Address setPostalCode(String value) {
	    setTextValue(value, this.postalCode);
		return this;
	}

	@Override
	public String getCountry() {
        return getTextValue(country);
	}

	@Override
	public Address setCountry(String value) {
	    setTextValue(value, this.country);
		return this;
	}

	@Override
	public float getLatitude() {
	    return getFloatValue(latitude);
	}

	@Override
	public Address setLatitude(float value) {
	    setFloatValue(value, this.latitude);
		return this;
	}

	@Override
	public float getLongitude() {
	    return getFloatValue(longitude);
	}

	@Override
	public Address setLongitude(float value) {
	    setFloatValue(value, this.longitude);
		return this;
	}



    @Override
    public UdbAddress save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



