package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbMessage extends AbstractUdbEntity<Message> implements Message {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static ShortIndex messageRecipientType;
	protected static MultiReferenceIndex privateRecipients;
	protected static SingleReferenceIndex groupFolder;
	protected static SingleReferenceIndex applicationFolder;
	protected static TextIndex subject;
	protected static TextIndex message;
	protected static ShortIndex messageType;
	protected static FileIndex file;
	protected static SingleReferenceIndex appointment;
	protected static SingleReferenceIndex appointmentSeries;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		messageRecipientType = (ShortIndex) tableIndex.getColumnIndex(FIELD_MESSAGE_RECIPIENT_TYPE);
		privateRecipients = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_PRIVATE_RECIPIENTS);
		groupFolder = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_GROUP_FOLDER);
		applicationFolder = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION_FOLDER);
		subject = (TextIndex) tableIndex.getColumnIndex(FIELD_SUBJECT);
		message = (TextIndex) tableIndex.getColumnIndex(FIELD_MESSAGE);
		messageType = (ShortIndex) tableIndex.getColumnIndex(FIELD_MESSAGE_TYPE);
		file = (FileIndex) tableIndex.getColumnIndex(FIELD_FILE);
		appointment = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPOINTMENT);
		appointmentSeries = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPOINTMENT_SERIES);
    }

    public static List<Message> getAll() {
        return new EntityBitSetList<>(Message.getBuilder(), table.getRecordBitSet());
    }

    public static List<Message> getDeletedRecords() {
        return new EntityBitSetList<>(Message.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<Message> sort(List<Message> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<Message> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, Message.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbMessage() {
        super(table);
    }

    public UdbMessage(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public Message build() {
        return new UdbMessage();
    }

    @Override
    public Message build(int id) {
        return new UdbMessage(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public Message setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public Message setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public Message setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public Message setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public Message setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public Message setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public Message setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public Message setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public Message setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public Message setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public Message setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public Message setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public Message setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public Message setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public Message setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public Message setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public MessageRecipientType getMessageRecipientType() {
	    return getEnumValue(messageRecipientType, MessageRecipientType.values());
	}

	@Override
	public Message setMessageRecipientType(MessageRecipientType value) {
    	setEnumValue(this.messageRecipientType, value);
		return this;
	}

	@Override
	public List<User> getPrivateRecipients() {
	    return getMultiReferenceValue(privateRecipients, User.getBuilder());
	}

	@Override
	public Message setPrivateRecipients(List<User> value) {
		setMultiReferenceValue(value, privateRecipients);
		return this;
	}

	@Override
	public int getPrivateRecipientsCount() {
	    return getMultiReferenceValueCount(privateRecipients, User.getBuilder());
	}

	@Override
	public Message setPrivateRecipients(User ... value) {
		setMultiReferenceValue(Arrays.asList(value), privateRecipients);
		return this;
	}

	@Override
	public BitSet getPrivateRecipientsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(privateRecipients, User.getBuilder());
	}

	@Override
	public Message addPrivateRecipients(List<User> value) {
		addMultiReferenceValue(value, privateRecipients);
		return this;
	}

	@Override
	public Message addPrivateRecipients(User ... value) {
		addMultiReferenceValue(Arrays.asList(value), privateRecipients);
		return this;
	}

	@Override
	public Message removePrivateRecipients(List<User> value) {
		removeMultiReferenceValue(value, privateRecipients);
		return this;
	}

	@Override
	public Message removePrivateRecipients(User ... value) {
		removeMultiReferenceValue(Arrays.asList(value), privateRecipients);
		return this;
	}

	@Override
	public Message removeAllPrivateRecipients() {
		removeAllMultiReferenceValue(privateRecipients);
		return this;
	}

	@Override
	public GroupFolder getGroupFolder() {
		if (isChanged(groupFolder)) {
			return (GroupFolder) getReferenceChangeValue(groupFolder);
		} else {
			int id = groupFolder.getValue(getId());
			if (id > 0) {
				return GroupFolder.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Message setGroupFolder(GroupFolder value) {
		setSingleReferenceValue(groupFolder, value, table);
		return this;
	}

	@Override
	public ApplicationFolder getApplicationFolder() {
		if (isChanged(applicationFolder)) {
			return (ApplicationFolder) getReferenceChangeValue(applicationFolder);
		} else {
			int id = applicationFolder.getValue(getId());
			if (id > 0) {
				return ApplicationFolder.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Message setApplicationFolder(ApplicationFolder value) {
		setSingleReferenceValue(applicationFolder, value, table);
		return this;
	}

	@Override
	public String getSubject() {
        return getTextValue(subject);
	}

	@Override
	public Message setSubject(String value) {
	    setTextValue(value, this.subject);
		return this;
	}

	@Override
	public String getMessage() {
        return getTextValue(message);
	}

	@Override
	public Message setMessage(String value) {
	    setTextValue(value, this.message);
		return this;
	}

	@Override
	public MessageType getMessageType() {
	    return getEnumValue(messageType, MessageType.values());
	}

	@Override
	public Message setMessageType(MessageType value) {
    	setEnumValue(this.messageType, value);
		return this;
	}

	@Override
	public FileValue getFile() {
		if (isChanged(file)) {
			return (FileValue) getChangedValue(file);
		} else {
			return file.getValue(getId());
		}
	}

	@Override
	public Message setFile(File value) {
	    FileValue storeFile = file.storeFile(value);
		setChangeValue(this.file, storeFile, table);
		return this;
	}

	@Override
	public Message setFile(File value, String fileName) {
	    FileValue storeFile = file.storeFile(value, fileName);
		setChangeValue(this.file, storeFile, table);
		return this;
	}

	@Override
	public Appointment getAppointment() {
		if (isChanged(appointment)) {
			return (Appointment) getReferenceChangeValue(appointment);
		} else {
			int id = appointment.getValue(getId());
			if (id > 0) {
				return Appointment.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Message setAppointment(Appointment value) {
		setSingleReferenceValue(appointment, value, table);
		return this;
	}

	@Override
	public AppointmentSeries getAppointmentSeries() {
		if (isChanged(appointmentSeries)) {
			return (AppointmentSeries) getReferenceChangeValue(appointmentSeries);
		} else {
			int id = appointmentSeries.getValue(getId());
			if (id > 0) {
				return AppointmentSeries.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Message setAppointmentSeries(AppointmentSeries value) {
		setSingleReferenceValue(appointmentSeries, value, table);
		return this;
	}



    @Override
    public UdbMessage save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



