package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbNewsBoardMessageQuery extends AbstractUdbQuery<NewsBoardMessage> implements NewsBoardMessageQuery {

    public UdbNewsBoardMessageQuery() {
        super(UdbNewsBoardMessage.table, NewsBoardMessage.getBuilder());
    }

    @Override
    public NewsBoardMessageQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public NewsBoardMessageQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public NewsBoardMessageQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public NewsBoardMessageQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbNewsBoardMessage.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public NewsBoardMessageQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbNewsBoardMessage.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public NewsBoardMessageQuery metaCreationDate(NumericFilter filter) {
		and(UdbNewsBoardMessage.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbNewsBoardMessage.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery metaCreatedBy(NumericFilter filter) {
		and(UdbNewsBoardMessage.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbNewsBoardMessage.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery metaModificationDate(NumericFilter filter) {
		and(UdbNewsBoardMessage.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbNewsBoardMessage.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery metaModifiedBy(NumericFilter filter) {
		and(UdbNewsBoardMessage.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbNewsBoardMessage.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery metaDeletionDate(NumericFilter filter) {
		and(UdbNewsBoardMessage.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbNewsBoardMessage.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery metaDeletedBy(NumericFilter filter) {
		and(UdbNewsBoardMessage.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbNewsBoardMessage.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery metaRestoreDate(NumericFilter filter) {
		and(UdbNewsBoardMessage.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbNewsBoardMessage.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery metaRestoredBy(NumericFilter filter) {
		and(UdbNewsBoardMessage.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbNewsBoardMessage.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery published(BooleanFilter filter) {
		and(UdbNewsBoardMessage.published.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orPublished(BooleanFilter filter) {
		or(UdbNewsBoardMessage.published.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery htmlMessage(TextFilter filter) {
		and(UdbNewsBoardMessage.htmlMessage.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orHtmlMessage(TextFilter filter) {
		or(UdbNewsBoardMessage.htmlMessage.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery language(TextFilter filter) {
		and(UdbNewsBoardMessage.language.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orLanguage(TextFilter filter) {
		or(UdbNewsBoardMessage.language.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery filterImages(NewsBoardMessageImageQuery query) {
		UdbNewsBoardMessageImageQuery udbQuery = (UdbNewsBoardMessageImageQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbNewsBoardMessage.images);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public NewsBoardMessageQuery images(MultiReferenceFilterType type, NewsBoardMessageImage ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (NewsBoardMessageImage value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbNewsBoardMessage.images.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery imagesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbNewsBoardMessage.images.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery images(MultiReferenceFilter filter) {
		and(UdbNewsBoardMessage.images.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orImages(MultiReferenceFilter filter) {
		or(UdbNewsBoardMessage.images.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery filterTranslations(NewsBoardMessageTranslationQuery query) {
		UdbNewsBoardMessageTranslationQuery udbQuery = (UdbNewsBoardMessageTranslationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbNewsBoardMessage.translations);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public NewsBoardMessageQuery translations(MultiReferenceFilterType type, NewsBoardMessageTranslation ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (NewsBoardMessageTranslation value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbNewsBoardMessage.translations.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery translationsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbNewsBoardMessage.translations.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery translations(MultiReferenceFilter filter) {
		and(UdbNewsBoardMessage.translations.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orTranslations(MultiReferenceFilter filter) {
		or(UdbNewsBoardMessage.translations.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery filterOrganizationField(OrganizationFieldQuery query) {
		UdbOrganizationFieldQuery udbQuery = (UdbOrganizationFieldQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbNewsBoardMessage.organizationField);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public NewsBoardMessageQuery organizationField(NumericFilter filter) {
		and(UdbNewsBoardMessage.organizationField.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orOrganizationField(NumericFilter filter) {
		or(UdbNewsBoardMessage.organizationField.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery filterOrganizationUnit(OrganizationUnitQuery query) {
		UdbOrganizationUnitQuery udbQuery = (UdbOrganizationUnitQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbNewsBoardMessage.organizationUnit);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public NewsBoardMessageQuery organizationUnit(NumericFilter filter) {
		and(UdbNewsBoardMessage.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageQuery orOrganizationUnit(NumericFilter filter) {
		or(UdbNewsBoardMessage.organizationUnit.createFilter(filter));
		return this;
	}


	@Override
	public UdbNewsBoardMessageQuery andOr(NewsBoardMessageQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public NewsBoardMessageQuery customFilter(Function<NewsBoardMessage, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(NewsBoardMessage.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



