package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface UserAcceptedPolicy extends Entity<UserAcceptedPolicy> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_LAST_ACCEPTED_PRIVACY_POLICY = "lastAcceptedPrivacyPolicy";
	final static String FIELD_LAST_ACCEPTED_TERMS_OF_USE = "lastAcceptedTermsOfUse";
	final static String FIELD_ACCEPT_ENTRIES = "acceptEntries";

    static UserAcceptedPolicy create() {
        return new UdbUserAcceptedPolicy();
    }

    static UserAcceptedPolicy create(int id) {
        return new UdbUserAcceptedPolicy(id, true);
    }

    static UserAcceptedPolicy getById(int id) {
        return new UdbUserAcceptedPolicy(id, false);
    }

    static EntityBuilder<UserAcceptedPolicy> getBuilder() {
        return new UdbUserAcceptedPolicy(0, false);
    }

    Instant getMetaCreationDate();

    UserAcceptedPolicy setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    UserAcceptedPolicy setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    UserAcceptedPolicy setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    UserAcceptedPolicy setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    UserAcceptedPolicy setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    UserAcceptedPolicy setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    UserAcceptedPolicy setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    UserAcceptedPolicy setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    UserAcceptedPolicy setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    UserAcceptedPolicy setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    UserAcceptedPolicy setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    UserAcceptedPolicy setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    UserAcceptedPolicy setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    UserAcceptedPolicy setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    UserAcceptedPolicy setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    UserAcceptedPolicy setMetaRestoredBy(int value);

    int getLastAcceptedPrivacyPolicy();

    UserAcceptedPolicy setLastAcceptedPrivacyPolicy(int value);

    int getLastAcceptedTermsOfUse();

    UserAcceptedPolicy setLastAcceptedTermsOfUse(int value);

    List<UserAcceptedPolicyEntries> getAcceptEntries();

    UserAcceptedPolicy setAcceptEntries(List<UserAcceptedPolicyEntries> value);

    int getAcceptEntriesCount();

    UserAcceptedPolicy setAcceptEntries(UserAcceptedPolicyEntries ... value);

    BitSet getAcceptEntriesAsBitSet();

    UserAcceptedPolicy addAcceptEntries(List<UserAcceptedPolicyEntries> value);

    UserAcceptedPolicy addAcceptEntries(UserAcceptedPolicyEntries ... value);

    UserAcceptedPolicy removeAcceptEntries(List<UserAcceptedPolicyEntries> value);

    UserAcceptedPolicy removeAcceptEntries(UserAcceptedPolicyEntries ... value);

    UserAcceptedPolicy removeAllAcceptEntries();


    static List<UserAcceptedPolicy> getAll() {
        return UdbUserAcceptedPolicy.getAll();
    }

    static List<UserAcceptedPolicy> getDeletedRecords() {
        return UdbUserAcceptedPolicy.getDeletedRecords();
    }

    static List<UserAcceptedPolicy> sort(List<UserAcceptedPolicy> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserAcceptedPolicy.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbUserAcceptedPolicy.getCount();
    }

    static UserAcceptedPolicyQuery filter() {
        return new UdbUserAcceptedPolicyQuery();
    }
}

