package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface UserAccessTokenQuery extends Query<UserAccessToken> {

    static UserAccessTokenQuery create() {
        return new UdbUserAccessTokenQuery();
    }

    UserAccessTokenQuery id(Integer... ids);

    UserAccessTokenQuery id(BitSet ids);

    UserAccessTokenQuery id(Collection<Integer> ids);

    UserAccessTokenQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    UserAccessTokenQuery parseFullTextFilter(String query, String... fieldNames);

	UserAccessTokenQuery metaCreationDate(NumericFilter filter);

	UserAccessTokenQuery orMetaCreationDate(NumericFilter filter);

	UserAccessTokenQuery metaCreatedBy(NumericFilter filter);

	UserAccessTokenQuery orMetaCreatedBy(NumericFilter filter);

	UserAccessTokenQuery metaDeletionDate(NumericFilter filter);

	UserAccessTokenQuery orMetaDeletionDate(NumericFilter filter);

	UserAccessTokenQuery metaDeletedBy(NumericFilter filter);

	UserAccessTokenQuery orMetaDeletedBy(NumericFilter filter);

	UserAccessTokenQuery metaRestoreDate(NumericFilter filter);

	UserAccessTokenQuery orMetaRestoreDate(NumericFilter filter);

	UserAccessTokenQuery metaRestoredBy(NumericFilter filter);

	UserAccessTokenQuery orMetaRestoredBy(NumericFilter filter);

	UserAccessTokenQuery filterUser(UserQuery query);

	UserAccessTokenQuery user(NumericFilter filter);

	UserAccessTokenQuery orUser(NumericFilter filter);

	UserAccessTokenQuery userAgentOnCreation(TextFilter filter);

	UserAccessTokenQuery orUserAgentOnCreation(TextFilter filter);

	UserAccessTokenQuery userAgentLastUsed(TextFilter filter);

	UserAccessTokenQuery orUserAgentLastUsed(TextFilter filter);

	UserAccessTokenQuery lastUsed(NumericFilter filter);

	UserAccessTokenQuery orLastUsed(NumericFilter filter);

	UserAccessTokenQuery valid(BooleanFilter filter);

	UserAccessTokenQuery orValid(BooleanFilter filter);

	UserAccessTokenQuery restApi(BooleanFilter filter);

	UserAccessTokenQuery orRestApi(BooleanFilter filter);

	UserAccessTokenQuery secureToken(TextFilter filter);

	UserAccessTokenQuery orSecureToken(TextFilter filter);


    UserAccessTokenQuery andOr(UserAccessTokenQuery... queries);

    UserAccessTokenQuery customFilter(Function<UserAccessToken, Boolean> customFilter);

    List<UserAccessToken> execute();

    List<UserAccessToken> executeOnDeletedRecords();

    UserAccessToken executeExpectSingleton();

    BitSet executeToBitSet();

    List<UserAccessToken> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<UserAccessToken> execute(boolean deletedRecords, String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<UserAccessToken> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

