package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface UserQuery extends Query<User> {

    static UserQuery create() {
        return new UdbUserQuery();
    }

    UserQuery id(Integer... ids);

    UserQuery id(BitSet ids);

    UserQuery id(Collection<Integer> ids);

    UserQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    UserQuery parseFullTextFilter(String query, String... fieldNames);

	UserQuery metaCreationDate(NumericFilter filter);

	UserQuery orMetaCreationDate(NumericFilter filter);

	UserQuery metaCreatedBy(NumericFilter filter);

	UserQuery orMetaCreatedBy(NumericFilter filter);

	UserQuery metaModificationDate(NumericFilter filter);

	UserQuery orMetaModificationDate(NumericFilter filter);

	UserQuery metaModifiedBy(NumericFilter filter);

	UserQuery orMetaModifiedBy(NumericFilter filter);

	UserQuery metaDeletionDate(NumericFilter filter);

	UserQuery orMetaDeletionDate(NumericFilter filter);

	UserQuery metaDeletedBy(NumericFilter filter);

	UserQuery orMetaDeletedBy(NumericFilter filter);

	UserQuery metaRestoreDate(NumericFilter filter);

	UserQuery orMetaRestoreDate(NumericFilter filter);

	UserQuery metaRestoredBy(NumericFilter filter);

	UserQuery orMetaRestoredBy(NumericFilter filter);

	UserQuery firstName(TextFilter filter);

	UserQuery orFirstName(TextFilter filter);

	UserQuery lastName(TextFilter filter);

	UserQuery orLastName(TextFilter filter);

	UserQuery profilePicture(BinaryFilter filter);

	UserQuery orProfilePicture(BinaryFilter filter);

	UserQuery profilePictureLarge(BinaryFilter filter);

	UserQuery orProfilePictureLarge(BinaryFilter filter);

	UserQuery languages(TextFilter filter);

	UserQuery orLanguages(TextFilter filter);

	UserQuery email(TextFilter filter);

	UserQuery orEmail(TextFilter filter);

	UserQuery mobile(TextFilter filter);

	UserQuery orMobile(TextFilter filter);

	UserQuery phone(TextFilter filter);

	UserQuery orPhone(TextFilter filter);

	UserQuery login(TextFilter filter);

	UserQuery orLogin(TextFilter filter);

	UserQuery lastLogin(NumericFilter filter);

	UserQuery orLastLogin(NumericFilter filter);

	UserQuery password(TextFilter filter);

	UserQuery orPassword(TextFilter filter);

	UserQuery theme(TextFilter filter);

	UserQuery orTheme(TextFilter filter);

	UserQuery userAccountStatus(EnumFilterType filterType, UserAccountStatus ... enums);

	UserQuery orUserAccountStatus(EnumFilterType filterType, UserAccountStatus ... enums);

	UserQuery filterAcceptedPolicies(UserAcceptedPolicyQuery query);

	UserQuery acceptedPolicies(NumericFilter filter);

	UserQuery orAcceptedPolicies(NumericFilter filter);

	UserQuery filterAddress(AddressQuery query);

	UserQuery address(NumericFilter filter);

	UserQuery orAddress(NumericFilter filter);

	UserQuery filterOrganizationUnit(OrganizationUnitQuery query);

	UserQuery organizationUnit(NumericFilter filter);

	UserQuery orOrganizationUnit(NumericFilter filter);

	UserQuery filterAccessTokens(UserAccessTokenQuery query);

	UserQuery accessTokens(MultiReferenceFilterType type, UserAccessToken ... value);

	UserQuery accessTokensCount(MultiReferenceFilterType type, int count);

	UserQuery accessTokens(MultiReferenceFilter filter);

	UserQuery orAccessTokens(MultiReferenceFilter filter);

	UserQuery filterRoleAssignments(UserRoleAssignmentQuery query);

	UserQuery roleAssignments(MultiReferenceFilterType type, UserRoleAssignment ... value);

	UserQuery roleAssignmentsCount(MultiReferenceFilterType type, int count);

	UserQuery roleAssignments(MultiReferenceFilter filter);

	UserQuery orRoleAssignments(MultiReferenceFilter filter);

	UserQuery filterAllGroupMemberships(UserGroupMembershipQuery query);

	UserQuery allGroupMemberships(MultiReferenceFilterType type, UserGroupMembership ... value);

	UserQuery allGroupMembershipsCount(MultiReferenceFilterType type, int count);

	UserQuery allGroupMemberships(MultiReferenceFilter filter);

	UserQuery orAllGroupMemberships(MultiReferenceFilter filter);

	UserQuery filterPrivateMessages(MessageQuery query);

	UserQuery privateMessages(MultiReferenceFilterType type, Message ... value);

	UserQuery privateMessagesCount(MultiReferenceFilterType type, int count);

	UserQuery privateMessages(MultiReferenceFilter filter);

	UserQuery orPrivateMessages(MultiReferenceFilter filter);


    UserQuery andOr(UserQuery... queries);

    UserQuery customFilter(Function<User, Boolean> customFilter);

    List<User> execute();

    List<User> executeOnDeletedRecords();

    User executeExpectSingleton();

    BitSet executeToBitSet();

    List<User> execute(String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<User> execute(boolean deletedRecords, String sortFieldName, boolean ascending, UserContext userContext, String ... path);

    List<User> execute(int startIndex, int length, Sorting sorting, UserContext userContext);

}

