/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.teamapps.application.api.application.AbstractApplicationBuilder;
import org.teamapps.application.api.application.perspective.PerspectiveBuilder;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.api.localization.LocalizationData;
import org.teamapps.application.api.localization.LocalizationLanguages;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.versioning.ApplicationVersion;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.controlcenter.accesscontrol.AccessControlAppRolePerspectiveBuilder;
import org.teamapps.application.server.controlcenter.accesscontrol.AccessControlPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationGroupsPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationProvisioningPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationUpdatesPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationsPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applocal.AppLocalAdministrationPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.database.DataBasePerspectiveBuilder;
import org.teamapps.application.server.controlcenter.monitoring.MonitoringPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationChartPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationFieldPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationUnitTypePerspectiveBuilder;
import org.teamapps.application.server.controlcenter.roles.RolesPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.roles.UserRoleAssignmentPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.systemlog.SystemLogPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.systenconfig.ApplicationConfigurationPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.translations.TranslationsPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.users.UsersPerspectiveBuilder;
import org.teamapps.application.server.system.config.SystemConfig;
import org.teamapps.model.ControlCenterSchema;
import org.teamapps.universaldb.schema.SchemaInfoProvider;

public class ControlCenterAppBuilder
extends AbstractApplicationBuilder {
    private ApplicationConfig<SystemConfig> applicationConfig;

    public ControlCenterAppBuilder() {
        super("controlCenter", ApplicationIcons.WINDOW_KEY, "application.title", "application.desc");
        SystemConfig config = new SystemConfig();
        this.applicationConfig = new ApplicationConfig();
        this.applicationConfig.setConfig((Object)config);
    }

    public List<PerspectiveBuilder> getPerspectiveBuilders() {
        return Arrays.asList(new PerspectiveBuilder[]{new UsersPerspectiveBuilder(), new OrganizationPerspectiveBuilder(), new RolesPerspectiveBuilder(), new AccessControlPerspectiveBuilder(), new AccessControlAppRolePerspectiveBuilder(), new ApplicationsPerspectiveBuilder(), new TranslationsPerspectiveBuilder(), new ApplicationConfigurationPerspectiveBuilder(), new SystemLogPerspectiveBuilder(), new MonitoringPerspectiveBuilder(), new DataBasePerspectiveBuilder(), new AppLocalAdministrationPerspectiveBuilder(), new ApplicationGroupsPerspectiveBuilder(), new ApplicationProvisioningPerspectiveBuilder(), new ApplicationUpdatesPerspectiveBuilder(), new OrganizationChartPerspectiveBuilder(), new OrganizationFieldPerspectiveBuilder(), new OrganizationUnitTypePerspectiveBuilder(), new UserRoleAssignmentPerspectiveBuilder()});
    }

    public ApplicationVersion getApplicationVersion() {
        return ApplicationVersion.create((int)0, (int)54);
    }

    public List<ApplicationRole> getApplicationRoles() {
        return Privileges.getRoles();
    }

    public List<PrivilegeGroup> getPrivilegeGroups() {
        return Privileges.getPrivileges();
    }

    public LocalizationData getLocalizationData() {
        return LocalizationData.createFromPropertyFiles((String)"org.teamapps.application.server.i18n.controlCenter", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (LocalizationLanguages)new LocalizationLanguages(new Locale[]{Locale.ENGLISH}).setMachineTranslatedLanguages(new Locale[]{Locale.GERMAN, Locale.FRENCH, Locale.ITALIAN, Locale.JAPANESE, Locale.CHINESE, Locale.forLanguageTag("bg"), Locale.forLanguageTag("cs"), Locale.forLanguageTag("da"), Locale.forLanguageTag("el"), Locale.forLanguageTag("es"), Locale.forLanguageTag("et"), Locale.forLanguageTag("fi"), Locale.forLanguageTag("hu"), Locale.forLanguageTag("lt"), Locale.forLanguageTag("lv"), Locale.forLanguageTag("nl"), Locale.forLanguageTag("pl"), Locale.forLanguageTag("pt"), Locale.forLanguageTag("ro"), Locale.forLanguageTag("ru"), Locale.forLanguageTag("sk"), Locale.forLanguageTag("sl"), Locale.forLanguageTag("sv"), Locale.forLanguageTag("fa"), Locale.forLanguageTag("iw"), Locale.forLanguageTag("hi"), Locale.forLanguageTag("hr"), Locale.forLanguageTag("in"), Locale.forLanguageTag("ko"), Locale.forLanguageTag("mk"), Locale.forLanguageTag("mn"), Locale.forLanguageTag("sr"), Locale.forLanguageTag("tr"), Locale.forLanguageTag("vi")}));
    }

    public static void main(String[] args) {
        Locale locale = new Locale("id");
        System.out.println(locale);
        System.out.println(Locale.forLanguageTag("he"));
    }

    public SchemaInfoProvider getDatabaseModel() {
        return new ControlCenterSchema();
    }

    public ApplicationConfig<SystemConfig> getApplicationConfig() {
        return this.applicationConfig;
    }

    public boolean isApplicationAccessible(ApplicationPrivilegeProvider privilegeProvider) {
        return privilegeProvider.isAllowed(Privileges.LAUNCH_APPLICATION);
    }
}

