/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.database;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.universaldb.query.SortDirection;
import org.teamapps.universaldb.query.Sorting;
import org.teamapps.ux.component.table.AbstractTableModel;
import org.teamapps.ux.component.timegraph.Interval;

public class TableExplorerModel
extends AbstractTableModel<Integer> {
    private final TableIndex tableIndex;
    private final boolean deletedRecords;
    private final ApplicationInstanceData applicationInstanceData;
    private int recordCount;
    private List<Integer> resultRecords;
    private String query;
    private Sorting currentSorting;
    private Interval timeLineFilterInterval;
    private Function<Integer, Long> timeFilterDataFunction;

    public TableExplorerModel(TableIndex tableIndex, boolean deletedRecords, ApplicationInstanceData applicationInstanceData) {
        this.tableIndex = tableIndex;
        this.deletedRecords = deletedRecords;
        this.applicationInstanceData = applicationInstanceData;
        this.executeQuery();
    }

    public ColumnIndex getDefaultTimeLineColumn() {
        if (!this.tableIndex.getTableConfig().getOption(5)) {
            List<ColumnIndex> timeLineColumns = this.getTimeLineColumns();
            return timeLineColumns.size() > 0 ? timeLineColumns.get(0) : null;
        }
        return this.deletedRecords ? this.tableIndex.getColumnIndex("metaDeletionDate") : this.tableIndex.getColumnIndex("metaModificationDate");
    }

    public List<ColumnIndex> getTimeLineColumns() {
        return this.tableIndex.getColumnIndices().stream().filter(c -> c.getColumnType().isDateBased()).collect(Collectors.toList());
    }

    public void setQuery(String query) {
        this.query = query;
        this.executeQuery();
        this.onAllDataChanged().fire();
    }

    public void setTimeLineFilter(String field, Interval interval) {
        if (interval == null || field == null || this.tableIndex.getColumnIndex(field) == null) {
            this.timeFilterDataFunction = null;
            this.timeLineFilterInterval = null;
        } else {
            this.timeLineFilterInterval = interval;
            this.timeFilterDataFunction = this.createTimeLineDataFunction(this.tableIndex.getColumnIndex(field));
        }
        this.executeQuery();
        this.onAllDataChanged().fire();
    }

    public Function<Integer, Long> createTimeLineDataFunction(ColumnIndex timeLineFilterColumn) {
        if (timeLineFilterColumn.getType() == IndexType.INT) {
            IntegerIndex index = (IntegerIndex)timeLineFilterColumn;
            return id -> (long)index.getValue(id.intValue()) * 1000L;
        }
        LongIndex index = (LongIndex)timeLineFilterColumn;
        return arg_0 -> ((LongIndex)index).getValue(arg_0);
    }

    private void executeQuery() {
        ColumnIndex columnIndex;
        BitSet recordBitSet = this.deletedRecords ? this.tableIndex.getDeletedRecords() : this.tableIndex.getRecords();
        List<Integer> result = null;
        if (this.query != null && !this.query.isBlank()) {
            Filter fullTextFilter = this.tableIndex.createFullTextFilter(this.query, new String[0]);
            recordBitSet = fullTextFilter.filter(recordBitSet);
        }
        if (this.timeFilterDataFunction != null && this.timeLineFilterInterval != null) {
            BitSet timeLineRecords = new BitSet();
            long min = this.timeLineFilterInterval.getMin();
            long max = this.timeLineFilterInterval.getMax();
            int id = recordBitSet.nextSetBit(0);
            while (id >= 0) {
                long value = this.timeFilterDataFunction.apply(id);
                if (value >= min && value <= max) {
                    timeLineRecords.set(id);
                }
                id = recordBitSet.nextSetBit(id + 1);
            }
            recordBitSet = timeLineRecords;
        }
        if (this.currentSorting != null && (columnIndex = this.tableIndex.getColumnIndex(this.currentSorting.getSortFieldName())) != null) {
            List sortEntries = SortEntry.createSortEntries((BitSet)recordBitSet, (SingleReferenceIndex[])new SingleReferenceIndex[0]);
            columnIndex.sortRecords(sortEntries, this.currentSorting.getSortDirection() == SortDirection.ASCENDING, (UserContext)this.applicationInstanceData.getUser());
            result = sortEntries.stream().map(entry -> entry.getId()).collect(Collectors.toList());
        }
        if (result == null) {
            result = new ArrayList<Integer>();
            int id = recordBitSet.nextSetBit(0);
            while (id >= 0) {
                result.add(id);
                id = recordBitSet.nextSetBit(id + 1);
            }
        }
        this.resultRecords = result;
        this.recordCount = this.resultRecords.size();
    }

    public int getCount() {
        return this.recordCount;
    }

    public void setSorting(String fieldName, boolean ascending) {
        this.currentSorting = fieldName == null ? null : new Sorting(fieldName, ascending);
        this.executeQuery();
    }

    public List<Integer> getRecords(int startIndex, int length) {
        return this.resultRecords.stream().skip(startIndex).limit(length).collect(Collectors.toList());
    }
}

