/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.organization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeType;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.organization.OrgChartData;
import org.teamapps.application.server.controlcenter.organization.OrgChartNode;
import org.teamapps.application.server.controlcenter.organization.OrgChartRow;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.Templates;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.charting.common.GraphNodeIcon;
import org.teamapps.ux.component.charting.common.GraphNodeImage;
import org.teamapps.ux.component.charting.tree.BaseTreeGraphNode;
import org.teamapps.ux.component.charting.tree.TreeGraph;
import org.teamapps.ux.component.charting.tree.TreeGraphNode;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.table.ListTable;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class OrganizationChartPerspective
extends AbstractManagedApplicationPerspective {
    public static final Privilege SHOW_UPWARDS_LEADERS = Privilege.create((PrivilegeType)PrivilegeType.READ, (String)"upwardLeaders", (Icon)ApplicationIcons.NAVIGATE_OPEN, (String)"organizationChart.showUpwardsLeaders");
    public static final Privilege SHOW_UPWARDS_ALL_ROLES = Privilege.create((PrivilegeType)PrivilegeType.READ, (String)"upwardAllRoles", (Icon)ApplicationIcons.NAVIGATE_OPEN, (String)"organizationChart.showUpwardsAllRoles");
    public static final Privilege SHOW_DOWNWARDS_LEADERS = Privilege.create((PrivilegeType)PrivilegeType.READ, (String)"downwardLeaders", (Icon)ApplicationIcons.NAVIGATE_CLOSE, (String)"organizationChart.showDownwardsLeaders");
    public static final Privilege SHOW_DOWNWARDS_ALL_ROLES = Privilege.create((PrivilegeType)PrivilegeType.READ, (String)"downwardsAllRoles", (Icon)ApplicationIcons.NAVIGATE_CLOSE, (String)"organizationChart.showDownwardsAllRoles");
    private final PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
    private final UserSessionData userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
    private TreeGraph<OrgChartNode> treeGraph;
    private float zoomFactor = 1.0f;
    private List<TreeGraphNode<OrgChartNode>> treeNodes;

    public OrganizationChartPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        if (OrganizationField.getCount() == 0) {
            return;
        }
        View masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.PIECES, (String)this.getLocalized("organizationChart.title"), null));
        masterView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.75f));
        View masterTableView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.PIECES, (String)this.getLocalized("organizationChart.title"), null));
        masterTableView.setVisible(false);
        ToolbarButtonGroup buttonGroup = masterTableView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton((ToolbarButton)ToolbarButton.create((Icon)ApplicationIcons.ELEMENTS_HIERARCHY, (String)this.getLocalized((String)"organizationChart.showOrgChart"), (String)this.getLocalized((String)"organizationChart.showOrgChart"))).onClick.addListener(() -> {
            masterTableView.setVisible(false);
            masterView.setVisible(true);
        });
        buttonGroup = masterView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton((ToolbarButton)ToolbarButton.create((Icon)ApplicationIcons.SPREADSHEET, (String)this.getLocalized((String)"organizationChart.showOrganizationTable"), (String)this.getLocalized((String)"organizationChart.displayOrgChartAsTable"))).onClick.addListener(() -> {
            masterTableView.setVisible(true);
            masterView.setVisible(false);
        });
        buttonGroup = masterView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton standardViewButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ELEMENTS_HIERARCHY, (String)this.getLocalized("organizationChart.standardView"), (String)this.getLocalized("organizationChart.standardView.desc")));
        ToolbarButton compactViewButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ELEMENTS_TREE, (String)this.getLocalized("organizationChart.compactView"), (String)this.getLocalized("organizationChart.compactView.desc")));
        buttonGroup = masterView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton zoomInButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ZOOM_IN, (String)this.getLocalized("org.teamapps.dictionary.zoomIn"), (String)this.getLocalized("org.teamapps.dictionary.zoomIn")));
        ToolbarButton zoomOutButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ZOOM_OUT, (String)this.getLocalized("org.teamapps.dictionary.zoomOut"), (String)this.getLocalized("org.teamapps.dictionary.zoomOut")));
        standardViewButton.onClick.addListener(() -> this.treeGraph.setCompact(false));
        compactViewButton.onClick.addListener(() -> this.treeGraph.setCompact(true));
        zoomInButton.onClick.addListener(() -> {
            this.zoomFactor *= 1.5f;
            this.treeGraph.setZoomFactor(this.zoomFactor);
            this.treeGraph.setNodes(this.treeNodes);
        });
        zoomOutButton.onClick.addListener(() -> {
            this.zoomFactor /= 1.5f;
            this.treeGraph.setZoomFactor(this.zoomFactor);
            this.treeGraph.setNodes(this.treeNodes);
        });
        OrganizationField organizationField = this.getOrganizationField() != null ? this.getOrganizationField() : OrganizationField.getAll().get(0);
        OrgChartData orgChartData = new OrgChartData(organizationField, this.getApplicationInstanceData());
        List<OrgChartRow> orgChartRows = orgChartData.getOrgChartRows();
        ListTable table = new ListTable();
        table.setDisplayAsList(true);
        table.setStripedRows(true);
        table.setRowHeight(36);
        table.setRecords(orgChartRows);
        PropertyProvider orgUnitPropertyProvider = UiUtils.createPropertyProvider(OrgChartNode::getOrgUnitIcon, null, OrgChartNode::getUnitNameWithPrefix, OrgChartNode::getUnitTypeName);
        PropertyProvider roleAssignmentPropertyProvider = UiUtils.createPropertyProvider(null, OrgChartNode::getUserImage, OrgChartNode::getUserFullName, OrgChartNode::getRoleName);
        TemplateField orgUnitField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_TWO_LINES, (PropertyProvider)orgUnitPropertyProvider);
        TemplateField leaderField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, (PropertyProvider)roleAssignmentPropertyProvider);
        TemplateField assistantField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, (PropertyProvider)roleAssignmentPropertyProvider);
        TemplateField otherField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, (PropertyProvider)roleAssignmentPropertyProvider);
        table.addColumn("unit", null, this.getLocalized("organization.organizationUnit"), (AbstractField)orgUnitField, 220).setValueExtractor(OrgChartRow::getOrgUnitNode);
        table.addColumn("leader", null, this.getLocalized("organizationChart.leadershipTask"), (AbstractField)leaderField, 230).setValueExtractor(OrgChartRow::getLeaderNode);
        table.addColumn("assistant", null, this.getLocalized("organizationChart.assistantMentorTask"), (AbstractField)assistantField, 230).setValueExtractor(OrgChartRow::getAssistantNode);
        table.addColumn("other", null, this.getLocalized("organizationChart.otherTasks"), (AbstractField)otherField, 250).setValueExtractor(OrgChartRow::getOtherNode);
        masterTableView.setComponent((Component)table);
        TextField searchField = new TextField();
        searchField.setShowClearButton(true);
        searchField.setEmptyText(this.getLocalized("org.teamapps.dictionary.search___"));
        searchField.onTextInput.addListener(query -> {
            List filteredRows = orgChartData.getOrgChartRows().stream().filter(row -> row.match((String)query)).collect(Collectors.toList());
            table.setRecords(filteredRows);
        });
        masterTableView.getPanel().setRightHeaderField((AbstractField)searchField);
        this.treeGraph = new TreeGraph();
        this.treeNodes = new ArrayList<TreeGraphNode<OrgChartNode>>();
        HashMap<OrganizationUnit, TreeGraphNode<OrgChartNode>> nodeByOrgUnit = new HashMap<OrganizationUnit, TreeGraphNode<OrgChartNode>>();
        for (OrgChartNode chartNode : orgChartData.getOrgChartNodes()) {
            TreeGraphNode<OrgChartNode> node2 = this.createNode(chartNode);
            this.treeNodes.add(node2);
            nodeByOrgUnit.put(chartNode.getOrganizationUnit(), node2);
        }
        this.treeNodes.forEach(node -> {
            node.setParent((TreeGraphNode)nodeByOrgUnit.get(((OrgChartNode)node.getRecord()).getOrganizationUnit().getParent()));
            node.setParentExpandable(node.getParent() != null);
        });
        this.treeGraph.setPropertyProvider(this.createOrgChartNodePropertyProvider());
        this.treeGraph.setHorizontalSiblingGap(40);
        this.treeGraph.setHorizontalNonSignlingGap(60);
        this.treeGraph.setVerticalLayerGap(75);
        this.treeGraph.setNodes(this.treeNodes);
        masterView.setComponent(this.treeGraph);
        Consumer<OrgChartNode> ensureOpenHandler = orgChartNode -> {
            for (TreeGraphNode<OrgChartNode> treeNode : this.treeNodes) {
                if (((OrgChartNode)treeNode.getRecord()).getOrganizationUnit().equals(orgChartNode.getOrganizationUnit())) {
                    treeNode.setParentExpanded(false);
                    treeNode.setExpanded(true);
                    this.treeGraph.updateNode(treeNode);
                    continue;
                }
                if (!treeNode.isParentExpanded()) {
                    treeNode.setParentExpanded(true);
                    this.treeGraph.updateNode(treeNode);
                }
                if (!treeNode.isExpanded()) continue;
                treeNode.setExpanded(false);
                this.treeGraph.updateNode(treeNode);
            }
            OrgChartNode node = orgChartNode;
            TreeGraphNode graphNode = (TreeGraphNode)nodeByOrgUnit.get(node.getOrganizationUnit());
            while (graphNode != null) {
                if ((graphNode = (TreeGraphNode)nodeByOrgUnit.get(((OrgChartNode)graphNode.getRecord()).getOrganizationUnit().getParent())) == null) continue;
                graphNode.setExpanded(true);
                this.treeGraph.updateNode(graphNode);
            }
        };
        TextField orgChartSearchField = new TextField();
        orgChartSearchField.setShowClearButton(true);
        orgChartSearchField.setEmptyText(this.getLocalized("org.teamapps.dictionary.search___"));
        orgChartSearchField.onTextInput.addListener(query -> this.treeNodes.stream().filter(node -> ((OrgChartNode)node.getRecord()).matches((String)query)).peek(node -> ensureOpenHandler.accept((OrgChartNode)node.getRecord())).findFirst().ifPresent(graphNode -> this.treeGraph.moveToNode(graphNode)));
        masterView.getPanel().setRightHeaderField((AbstractField)orgChartSearchField);
    }

    private TreeGraphNode<OrgChartNode> createNode(OrgChartNode chartNode) {
        TreeGraphNode node = new TreeGraphNode();
        node.setRecord((Object)chartNode);
        node.setTemplate((Template)Templates.ORGANIZATION_GRAPH_TEMPLATE);
        node.setWidth(240);
        node.setHeight(68);
        node.setBorderRadius(10.0f);
        node.setBorderWidth(1.0f);
        node.setConnectorLineColor((Color)Color.MATERIAL_BLUE_700);
        node.setBorderColor((Color)Color.MATERIAL_BLUE_700);
        node.setBackgroundColor((Color)Color.MATERIAL_BLUE_100);
        node.setExpanded(false);
        if (chartNode.getUserImage() != null) {
            node.setImage(new GraphNodeImage(chartNode.getUserImage(), 70, 70).setBorderColor((Color)Color.MATERIAL_BLUE_700).setBorderWidth(1.0f).setCenterLeftDistance(0).setCenterTopDistance(34).setCornerShape(GraphNodeImage.CornerShape.CIRCLE));
        } else {
            node.setIcon(new GraphNodeIcon(chartNode.getOrgUnitIcon(), 54));
        }
        List sideNodes = chartNode.getSubNodes().stream().map(this::createSideNode).collect(Collectors.toList());
        node.setSideListNodes(sideNodes);
        return node;
    }

    private BaseTreeGraphNode<OrgChartNode> createSideNode(OrgChartNode chartNode) {
        BaseTreeGraphNode node = new BaseTreeGraphNode();
        node.setRecord((Object)chartNode);
        node.setWidth(200);
        node.setHeight(40);
        node.setBorderRadius(7.0f);
        node.setBorderWidth(1.0f);
        RgbaColor borderColor = Color.MATERIAL_GREY_700;
        RgbaColor backgroundColor = Color.MATERIAL_GREY_100;
        Templates template = Templates.ORGANIZATION_GRAPH_SMALL_GREY_TEMPLATE;
        switch (chartNode.getRoleType()) {
            case LEADER: {
                borderColor = Color.MATERIAL_BLUE_700;
                backgroundColor = Color.MATERIAL_BLUE_100;
                template = Templates.ORGANIZATION_GRAPH_SMALL_BlUE_TEMPLATE;
                break;
            }
            case ASSISTANT: 
            case MENTOR: 
            case ADMINISTRATOR: {
                borderColor = Color.MATERIAL_GREEN_900;
                backgroundColor = Color.MATERIAL_GREEN_100;
                template = Templates.ORGANIZATION_GRAPH_SMALL_GREEN_TEMPLATE;
                break;
            }
            case OTHER: {
                borderColor = Color.MATERIAL_GREY_700;
                backgroundColor = Color.MATERIAL_GREY_100;
                template = Templates.ORGANIZATION_GRAPH_SMALL_GREY_TEMPLATE;
            }
        }
        node.setTemplate((Template)template);
        node.setBorderColor((Color)borderColor);
        node.setBackgroundColor((Color)backgroundColor);
        node.setConnectorLineColor((Color)borderColor);
        if (chartNode.getUserImage() != null) {
            node.setImage(new GraphNodeImage(chartNode.getUserImage(), 55, 55).setBorderColor((Color)borderColor).setBorderWidth(1.0f).setCenterLeftDistance(0).setCenterTopDistance(20).setCornerShape(GraphNodeImage.CornerShape.CIRCLE));
        } else {
            node.setIcon(new GraphNodeIcon(chartNode.getOrgUnitIcon(), 32));
        }
        return node;
    }

    private PropertyProvider<OrgChartNode> createOrgChartNodePropertyProvider() {
        return (orgChartNode, collection) -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("caption", orgChartNode.getUnitNameWithPrefix());
            map.put("description", orgChartNode.getUserFullName());
            map.put("line3", orgChartNode.getRoleName());
            return map;
        };
    }
}

