/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap.installer;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.server.system.bootstrap.ApplicationInfo;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationArtifactInstallationPhase;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationInstallationPhase;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationJarInstallationPhase;
import org.teamapps.application.server.system.bootstrap.installer.DataModelInstallationPhase;
import org.teamapps.application.server.system.bootstrap.installer.LocalizationDataInstallationPhase;
import org.teamapps.application.server.system.bootstrap.installer.PerspectiveDataInstallationPhase;
import org.teamapps.application.server.system.bootstrap.installer.PrivilegeDataInstallationPhase;
import org.teamapps.application.server.system.config.LocalizationConfig;
import org.teamapps.application.server.system.localization.LocalizationUtil;
import org.teamapps.application.server.system.machinetranslation.TranslationService;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationVersion;
import org.teamapps.universaldb.UniversalDB;

public class ApplicationInstaller {
    private final ApplicationInfo applicationInfo;
    private final UniversalDB universalDB;
    private final TranslationService translationService;
    private final LocalizationConfig localizationConfig;
    private final List<ApplicationInstallationPhase> applicationInstallationPhases;

    public static ApplicationInstaller createJarInstaller(File applicationJar, UniversalDB universalDB, TranslationService translationService, LocalizationConfig localizationConfig) {
        return new ApplicationInstaller(new ApplicationInfo(applicationJar), universalDB, translationService, localizationConfig);
    }

    public static ApplicationInstaller createClassInstaller(BaseApplicationBuilder baseApplicationBuilder, UniversalDB universalDB, TranslationService translationService, LocalizationConfig localizationConfig) {
        return new ApplicationInstaller(new ApplicationInfo(baseApplicationBuilder), universalDB, translationService, localizationConfig);
    }

    private ApplicationInstaller(ApplicationInfo applicationInfo, UniversalDB universalDB, TranslationService translationService, LocalizationConfig localizationConfig) {
        this.applicationInfo = applicationInfo;
        this.universalDB = universalDB;
        this.translationService = translationService;
        this.localizationConfig = localizationConfig;
        this.applicationInstallationPhases = Arrays.asList(new ApplicationJarInstallationPhase(), new ApplicationArtifactInstallationPhase(), new DataModelInstallationPhase(universalDB), new LocalizationDataInstallationPhase(localizationConfig), new PrivilegeDataInstallationPhase(), new PerspectiveDataInstallationPhase());
    }

    public boolean isInstalled() {
        Application application;
        if (!this.applicationInfo.isChecked()) {
            this.checkApplication();
        }
        if ((application = this.applicationInfo.getApplication()) == null) {
            return false;
        }
        String version = this.applicationInfo.getBaseApplicationBuilder().getApplicationVersion().getVersion();
        ApplicationVersion matchingVersion = application.getVersions().stream().filter(v -> v.getVersion().equals(version)).findFirst().orElse(null);
        return matchingVersion != null;
    }

    public ApplicationInfo checkApplication() {
        this.applicationInstallationPhases.forEach(phase -> phase.checkApplication(this.applicationInfo));
        this.applicationInfo.setChecked(true);
        return this.applicationInfo;
    }

    public boolean installApplication() {
        if (this.applicationInfo.isChecked() && this.applicationInfo.getErrors().isEmpty()) {
            this.applicationInstallationPhases.forEach(phase -> phase.installApplication(this.applicationInfo));
            this.applicationInfo.getApplication().setInstalledVersion(this.applicationInfo.getApplicationVersion()).save();
            LocalizationUtil.translateAllApplicationValues(this.translationService, this.applicationInfo.getApplication(), this.localizationConfig);
            this.applicationInfo.getBaseApplicationBuilder().getOnApplicationInstalled().fire();
            return true;
        }
        return false;
    }

    public LoadedApplication loadApplication() {
        if (this.applicationInfo.isChecked() && this.applicationInfo.getErrors().isEmpty()) {
            this.applicationInfo.createLoadedApplication();
            this.applicationInstallationPhases.forEach(phase -> phase.loadApplication(this.applicationInfo));
            ClassLoader classLoader = this.applicationInfo.getApplicationClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            String applicationConfig = this.applicationInfo.getBaseApplicationBuilder().getApplicationConfigXml(classLoader);
            Application application = this.applicationInfo.getApplication();
            if (applicationConfig != null && application.getConfig() != null) {
                try {
                    this.applicationInfo.getBaseApplicationBuilder().updateConfig(application.getConfig(), classLoader);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.applicationInfo.getBaseApplicationBuilder().getOnApplicationLoaded().fire();
            return this.applicationInfo.getLoadedApplication();
        }
        return null;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }
}

