/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap.installer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeGroupType;
import org.teamapps.application.server.system.bootstrap.ApplicationInfo;
import org.teamapps.application.server.system.bootstrap.ApplicationInfoDataElement;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationInstallationPhase;
import org.teamapps.application.server.system.privilege.ApplicationScopePrivilegeProvider;
import org.teamapps.application.server.system.utils.ValueCompare;
import org.teamapps.application.tools.KeyCompare;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPrivilege;
import org.teamapps.model.controlcenter.ApplicationPrivilegeGroup;
import org.teamapps.model.controlcenter.ApplicationPrivilegeGroupType;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.pojo.Entity;

public class PrivilegeDataInstallationPhase
implements ApplicationInstallationPhase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void checkApplication(ApplicationInfo applicationInfo) {
        try {
            if (!applicationInfo.getErrors().isEmpty()) {
                return;
            }
            BaseApplicationBuilder baseApplicationBuilder = applicationInfo.getBaseApplicationBuilder();
            List privilegeGroups = baseApplicationBuilder.getPrivilegeGroups();
            if (privilegeGroups == null) {
                applicationInfo.addError("Missing privileges");
                return;
            }
            ApplicationInfoDataElement dataInfo = new ApplicationInfoDataElement();
            Application application = applicationInfo.getApplication();
            List<String> privilegeGroupInfoData = this.getPrivilegeGroupInfoData(privilegeGroups);
            dataInfo.setData(String.join((CharSequence)"\n", privilegeGroupInfoData));
            if (application == null) {
                dataInfo.setDataAdded(privilegeGroupInfoData);
            } else {
                List<ApplicationPrivilegeGroup> applicationPrivilegeGroups = this.getApplicationPrivilegeGroups(application);
                KeyCompare keyCompare = new KeyCompare((Collection)privilegeGroups, applicationPrivilegeGroups, PrivilegeGroup::getName, ApplicationPrivilegeGroup::getName);
                List newPrivilegeGroups = keyCompare.getAEntriesNotInB();
                dataInfo.setDataAdded(this.getPrivilegeGroupInfoData(newPrivilegeGroups));
                List removedPrivilegeGroups = keyCompare.getBEntriesNotInA();
                dataInfo.setDataRemoved(this.getApplicationPrivilegeGroupInfoData(removedPrivilegeGroups));
                List existingGroups = keyCompare.getAEntriesInB();
                for (PrivilegeGroup privilegeGroup : existingGroups) {
                    KeyCompare keyCompare2 = new KeyCompare((Collection)privilegeGroup.getPrivileges(), ((ApplicationPrivilegeGroup)keyCompare.getB((Object)privilegeGroup)).getPrivileges(), Privilege::getName, ApplicationPrivilege::getName);
                }
            }
            applicationInfo.setPrivilegeData(dataInfo);
        }
        catch (Exception e) {
            applicationInfo.addError("Error checking privileges:" + e.getMessage());
            LOGGER.error("Error checking privileges:", (Throwable)e);
        }
    }

    @Override
    public void installApplication(ApplicationInfo applicationInfo) {
        BaseApplicationBuilder baseApplicationBuilder = applicationInfo.getBaseApplicationBuilder();
        List privilegeGroups = baseApplicationBuilder.getPrivilegeGroups();
        Application application = applicationInfo.getApplication();
        List<ApplicationPrivilegeGroup> applicationPrivilegeGroups = this.getApplicationPrivilegeGroups(application);
        KeyCompare keyCompare = new KeyCompare((Collection)privilegeGroups, applicationPrivilegeGroups, PrivilegeGroup::getName, ApplicationPrivilegeGroup::getName);
        List newPrivilegeGroups = keyCompare.getAEntriesNotInB();
        newPrivilegeGroups.forEach(group -> this.createApplicationPrivilegeGroup((PrivilegeGroup)group, application));
        List removedPrivilegeGroups = keyCompare.getBEntriesNotInA();
        removedPrivilegeGroups.forEach(Entity::delete);
        List existingGroups = keyCompare.getAEntriesInB();
        for (PrivilegeGroup group2 : existingGroups) {
            ApplicationPrivilegeGroup applicationPrivilegeGroup = (ApplicationPrivilegeGroup)keyCompare.getB((Object)group2);
            ValueCompare valueCompare = new ValueCompare().check(IconUtils.encodeNoStyle((Icon)group2.getIcon()), applicationPrivilegeGroup.getIcon()).check(group2.getName(), applicationPrivilegeGroup.getName()).check(group2.getTitleKey(), applicationPrivilegeGroup.getTitleKey()).check(group2.getDescriptionKey(), applicationPrivilegeGroup.getDescriptionKey());
            if (valueCompare.isDifferent()) {
                applicationPrivilegeGroup.setIcon(IconUtils.encodeNoStyle((Icon)group2.getIcon())).setName(group2.getName()).setTitleKey(group2.getTitleKey()).setDescriptionKey(group2.getDescriptionKey()).save();
            }
            KeyCompare privilegeCompare = new KeyCompare((Collection)group2.getPrivileges(), applicationPrivilegeGroup.getPrivileges(), Privilege::getName, ApplicationPrivilege::getName);
            List newPrivileges = privilegeCompare.getAEntriesNotInB();
            newPrivileges.forEach(privilege -> this.createApplicationPrivilege(applicationPrivilegeGroup, (Privilege)privilege));
            List removedPrivileges = privilegeCompare.getBEntriesNotInA();
            removedPrivileges.forEach(Entity::delete);
            List existingPrivileges = privilegeCompare.getAEntriesInB();
            for (Privilege existingPrivilege : existingPrivileges) {
                ApplicationPrivilege applicationPrivilege = (ApplicationPrivilege)privilegeCompare.getB((Object)existingPrivilege);
                if (!new ValueCompare().check(IconUtils.encodeNoStyle((Icon)existingPrivilege.getIcon()), applicationPrivilege.getIcon()).check(existingPrivilege.getTitleKey(), applicationPrivilege.getTitleKey()).isDifferent()) continue;
                applicationPrivilege.setIcon(IconUtils.encodeNoStyle((Icon)existingPrivilege.getIcon())).setTitleKey(existingPrivilege.getTitleKey()).save();
            }
        }
    }

    @Override
    public void loadApplication(ApplicationInfo applicationInfo) {
        applicationInfo.getLoadedApplication().setAppPrivilegeProvider(new ApplicationScopePrivilegeProvider(applicationInfo.getBaseApplicationBuilder()));
    }

    private List<ApplicationPrivilegeGroup> getApplicationPrivilegeGroups(Application application) {
        return ApplicationPrivilegeGroup.filter().application(NumericFilter.equalsFilter((Number)application.getId())).execute();
    }

    private void createApplicationPrivilegeGroup(PrivilegeGroup group, Application application) {
        ApplicationPrivilegeGroup applicationPrivilegeGroup = (ApplicationPrivilegeGroup)ApplicationPrivilegeGroup.create().setApplication(application).setIcon(IconUtils.encodeNoStyle((Icon)group.getIcon())).setName(group.getName()).setTitleKey(group.getTitleKey()).setDescriptionKey(group.getDescriptionKey()).setApplicationPrivilegeGroupType(this.getType(group.getType())).save();
        for (Privilege privilege : group.getPrivileges()) {
            this.createApplicationPrivilege(applicationPrivilegeGroup, privilege);
        }
    }

    private void createApplicationPrivilege(ApplicationPrivilegeGroup applicationPrivilegeGroup, Privilege privilege) {
        ApplicationPrivilege.create().setPrivilegeGroup(applicationPrivilegeGroup).setIcon(IconUtils.encodeNoStyle((Icon)privilege.getIcon())).setName(privilege.getName()).setTitleKey(privilege.getTitleKey()).save();
    }

    private ApplicationPrivilegeGroupType getType(PrivilegeGroupType groupType) {
        switch (groupType) {
            case SIMPLE_PRIVILEGE: {
                return ApplicationPrivilegeGroupType.SIMPLE_PRIVILEGE;
            }
            case SIMPLE_ORGANIZATIONAL_PRIVILEGE: {
                return ApplicationPrivilegeGroupType.SIMPLE_ORGANIZATIONAL_PRIVILEGE;
            }
            case SIMPLE_CUSTOM_OBJECT_PRIVILEGE: {
                return ApplicationPrivilegeGroupType.SIMPLE_CUSTOM_OBJECT_PRIVILEGE;
            }
            case STANDARD_PRIVILEGE_GROUP: {
                return ApplicationPrivilegeGroupType.STANDARD_PRIVILEGE_GROUP;
            }
            case ORGANIZATIONAL_PRIVILEGE_GROUP: {
                return ApplicationPrivilegeGroupType.ORGANIZATIONAL_PRIVILEGE_GROUP;
            }
            case CUSTOM_OBJECT_PRIVILEGE_GROUP: {
                return ApplicationPrivilegeGroupType.CUSTOM_OBJECT_PRIVILEGE_GROUP;
            }
            case ROLE_ASSIGNMENT_DELEGATED_CUSTOM_PRIVILEGE_GROUP: {
                return ApplicationPrivilegeGroupType.ROLE_ASSIGNMENT_DELEGATED_CUSTOM_PRIVILEGE_GROUP;
            }
        }
        return null;
    }

    private List<String> getPrivilegeGroupInfoData(List<PrivilegeGroup> privilegeGroups) {
        ArrayList<String> infoData = new ArrayList<String>();
        for (PrivilegeGroup privilegeGroup : privilegeGroups) {
            infoData.add(privilegeGroup.getName() + ": " + privilegeGroup.getType().name());
            for (Privilege privilege : privilegeGroup.getPrivileges()) {
                infoData.add(" -> " + privilege.getName());
            }
        }
        return infoData;
    }

    private List<String> getApplicationPrivilegeGroupInfoData(List<ApplicationPrivilegeGroup> privilegeGroups) {
        ArrayList<String> infoData = new ArrayList<String>();
        for (ApplicationPrivilegeGroup privilegeGroup : privilegeGroups) {
            infoData.add(privilegeGroup.getName() + ": " + (privilegeGroup.getApplicationPrivilegeGroupType() != null ? privilegeGroup.getApplicationPrivilegeGroupType().name() : null));
            for (ApplicationPrivilege privilege : privilegeGroup.getPrivileges()) {
                infoData.add(" -> " + privilege.getName());
            }
        }
        return infoData;
    }
}

