/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.utils.RoleUtils;
import org.teamapps.model.controlcenter.Group;
import org.teamapps.model.controlcenter.GroupMemberType;
import org.teamapps.model.controlcenter.GroupMembershipDefinition;
import org.teamapps.model.controlcenter.GroupMembershipRole;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserGroupMembership;
import org.teamapps.model.controlcenter.UserRoleAssignment;

public class GroupMembershipHandler {
    public synchronized void updateAllGroupMemberships() {
        for (Group group : Group.getAll()) {
            this.updateGroupUserMemberships(group);
        }
    }

    public synchronized void updateGroupUserMemberships(Group group) {
        ArrayList<UserGroupMembership> userMemberships = new ArrayList<UserGroupMembership>();
        HashSet<User> userMemberSet = new HashSet<User>();
        User owner = group.getOwner();
        if (owner != null) {
            userMemberSet.add(owner);
            userMemberships.add(this.createUserMembership(owner, group, GroupMembershipRole.OWNER));
        }
        for (User user : group.getModerators()) {
            if (userMemberSet.contains(user)) continue;
            userMemberSet.add(user);
            userMemberships.add(this.createUserMembership(user, group, GroupMembershipRole.MODERATOR));
        }
        for (User user : group.getMentors()) {
            if (userMemberSet.contains(user)) continue;
            userMemberSet.add(user);
            userMemberships.add(this.createUserMembership(user, group, GroupMembershipRole.MENTOR));
        }
        group.getMembershipDefinitions().stream().filter(definition -> definition.getGroupMemberType() == GroupMemberType.USER).forEach(definition -> {
            if (!userMemberSet.contains(definition.getUser())) {
                userMemberSet.add(definition.getUser());
                userMemberships.add(this.createUserMembership(definition.getUser(), group, GroupMembershipRole.PARTICIPANT));
            }
        });
        group.getMembershipDefinitions().stream().filter(definition -> definition.getGroupMemberType() == GroupMemberType.ROLE_MEMBER).forEach(definition -> {
            List<UserRoleAssignment> userRoleAssignments = RoleUtils.getUserRoleAssignments(definition.getRole(), true, definition.getOrganizationUnit(), definition.getOrganizationUnitTypesFilter());
            for (UserRoleAssignment assignment : userRoleAssignments) {
                if (userMemberSet.contains(assignment.getUser())) continue;
                userMemberSet.add(assignment.getUser());
                userMemberships.add(this.createUserMembership(assignment.getUser(), group, GroupMembershipRole.PARTICIPANT));
            }
        });
        group.getMembershipDefinitions().stream().filter(definition -> definition.getGroupMemberType() == GroupMemberType.USER_CONTAINER).forEach(definition -> {
            Set<User> users = OrganizationUtils.getAllUsers(definition.getOrganizationUnit(), definition.getOrganizationUnitTypesFilter());
            for (User user : users) {
                if (userMemberSet.contains(user)) continue;
                userMemberSet.add(user);
                userMemberships.add(this.createUserMembership(user, group, GroupMembershipRole.PARTICIPANT));
            }
        });
        HashSet<Group> memberGroupSet = new HashSet<Group>();
        this.calculateContainedMembershipGroups(group, memberGroupSet);
        memberGroupSet.remove(group);
        for (Group memberGroup : memberGroupSet) {
            Set<User> users = this.calculateNestedGroupMembers(memberGroup);
            for (User user : users) {
                if (userMemberSet.contains(user)) continue;
                userMemberSet.add(user);
                userMemberships.add(this.createUserMembership(user, group, GroupMembershipRole.PARTICIPANT));
            }
        }
        List<UserGroupMembership> list = group.getUserMemberships();
        HashMap currentMembershipMap = new HashMap();
        list.forEach(membership -> currentMembershipMap.put(membership.getUser(), membership));
        HashMap userMembershipMap = new HashMap();
        userMemberships.forEach(membership -> userMembershipMap.put(membership.getUser(), membership));
        ArrayList<UserGroupMembership> removeMemberships = new ArrayList<UserGroupMembership>();
        for (UserGroupMembership membership2 : list) {
            if (userMembershipMap.containsKey(membership2.getUser())) continue;
            removeMemberships.add(membership2);
        }
        ArrayList<UserGroupMembership> arrayList = new ArrayList<UserGroupMembership>();
        for (UserGroupMembership membership3 : userMemberships) {
            if (currentMembershipMap.containsKey(membership3.getUser())) continue;
            arrayList.add(membership3);
        }
        if (!removeMemberships.isEmpty() || !arrayList.isEmpty()) {
            if (list.size() / 20 > removeMemberships.size() + arrayList.size()) {
                group.removeUserMemberships(removeMemberships).addUserMemberships(arrayList).save();
            } else {
                group.setUserMemberships(userMemberships).save();
            }
        }
    }

    private Set<User> calculateNestedGroupMembers(Group group) {
        HashSet<User> userMemberSet = new HashSet<User>();
        User owner = group.getOwner();
        if (owner != null) {
            userMemberSet.add(owner);
        }
        for (User moderator : group.getModerators()) {
            if (userMemberSet.contains(moderator)) continue;
            userMemberSet.add(moderator);
        }
        for (User mentor : group.getMentors()) {
            if (userMemberSet.contains(mentor)) continue;
            userMemberSet.add(mentor);
        }
        group.getMembershipDefinitions().stream().filter(definition -> definition.getGroupMemberType() == GroupMemberType.USER).forEach(definition -> {
            if (!userMemberSet.contains(definition.getUser())) {
                userMemberSet.add(definition.getUser());
            }
        });
        group.getMembershipDefinitions().stream().filter(definition -> definition.getGroupMemberType() == GroupMemberType.ROLE_MEMBER).forEach(definition -> {
            List<UserRoleAssignment> userRoleAssignments = RoleUtils.getUserRoleAssignments(definition.getRole(), true, definition.getOrganizationUnit(), definition.getOrganizationUnitTypesFilter());
            for (UserRoleAssignment assignment : userRoleAssignments) {
                if (userMemberSet.contains(assignment.getUser())) continue;
                userMemberSet.add(assignment.getUser());
            }
        });
        group.getMembershipDefinitions().stream().filter(definition -> definition.getGroupMemberType() == GroupMemberType.USER_CONTAINER).forEach(definition -> {
            Set<User> users = OrganizationUtils.getAllUsers(definition.getOrganizationUnit(), definition.getOrganizationUnitTypesFilter());
            for (User user : users) {
                if (userMemberSet.contains(user)) continue;
                userMemberSet.add(user);
            }
        });
        return userMemberSet;
    }

    private void calculateContainedMembershipGroups(Group group, Set<Group> memberGroupSet) {
        group.getMembershipDefinitions().stream().filter(membershipDefinition -> membershipDefinition.getGroupMemberType() == GroupMemberType.GROUP).map(GroupMembershipDefinition::getGroup).filter(memberGroup -> !memberGroupSet.contains(memberGroup)).forEach(memberGroup -> {
            memberGroupSet.add((Group)memberGroup);
            this.calculateContainedMembershipGroups((Group)memberGroup, memberGroupSet);
        });
    }

    private UserGroupMembership createUserMembership(User user, Group group, GroupMembershipRole role) {
        return UserGroupMembership.create().setUser(user).setGroup(group).setGroupMembershipRole(role);
    }
}

