/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.utils;

import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationGroup;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class ApplicationUiUtils {
    public static ComboBox<Application> createApplicationComboBox(Template template, UserSessionData userSessionData) {
        ComboBox comboBox = new ComboBox(template);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        PropertyProvider<Application> propertyProvider = PropertyProviders.createApplicationPropertyProvider(userSessionData);
        comboBox.setPropertyProvider(propertyProvider);
        Function<Application, String> recordToStringFunction = application -> (String)propertyProvider.getValues(application, null).get("caption");
        comboBox.setRecordToStringFunction(recordToStringFunction);
        comboBox.setModel(query -> query == null || query.isBlank() ? Application.getAll() : Application.getAll().stream().filter(app -> ((String)recordToStringFunction.apply((Application)app)).toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList()));
        return comboBox;
    }

    public static ComboBox<ManagedApplication> createManagedApplicationComboBox(Template template, UserSessionData userSessionData) {
        ComboBox comboBox = new ComboBox(template);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        PropertyProvider<ManagedApplication> propertyProvider = PropertyProviders.createManagedApplicationPropertyProvider(userSessionData);
        comboBox.setPropertyProvider(propertyProvider);
        Function<ManagedApplication, String> recordToStringFunction = application -> (String)propertyProvider.getValues(application, null).get("caption");
        comboBox.setRecordToStringFunction(recordToStringFunction);
        comboBox.setModel(query -> query == null || query.isBlank() ? ManagedApplication.getAll() : ManagedApplication.getAll().stream().filter(app -> ((String)recordToStringFunction.apply((ManagedApplication)app)).toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList()));
        return comboBox;
    }

    public static ComboBox<ManagedApplicationPerspective> createManagedApplicationPerspectiveComboBox(Template template, UserSessionData userSessionData) {
        ComboBox comboBox = new ComboBox(template);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        PropertyProvider<ManagedApplicationPerspective> propertyProvider = PropertyProviders.createManagedApplicationPerspectivePropertyProvider(userSessionData);
        comboBox.setPropertyProvider(propertyProvider);
        Function<ManagedApplicationPerspective, String> recordToStringFunction = application -> (String)propertyProvider.getValues(application, null).get("caption");
        comboBox.setRecordToStringFunction(recordToStringFunction);
        comboBox.setModel(query -> query == null || query.isBlank() ? ManagedApplicationPerspective.getAll() : ManagedApplicationPerspective.getAll().stream().filter(app -> ((String)recordToStringFunction.apply((ManagedApplicationPerspective)app)).toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList()));
        return comboBox;
    }

    public static ComboBox<ManagedApplicationGroup> createApplicationGroupComboBox(Template template, ApplicationInstanceData applicationInstanceData) {
        ComboBox comboBox = new ComboBox(template);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        PropertyProvider<ManagedApplicationGroup> propertyProvider = PropertyProviders.createManagedApplicationGroupPropertyProvider(applicationInstanceData);
        comboBox.setPropertyProvider(propertyProvider);
        Function<ManagedApplicationGroup, String> recordToStringFunction = group -> (String)propertyProvider.getValues(group, null).get("caption");
        comboBox.setRecordToStringFunction(recordToStringFunction);
        comboBox.setModel(query -> query == null || query.isBlank() ? ManagedApplicationGroup.getAll() : ManagedApplicationGroup.getAll().stream().filter(group -> ((String)recordToStringFunction.apply((ManagedApplicationGroup)group)).toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList()));
        return comboBox;
    }
}

