/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.ui.localize;

import java.util.function.Supplier;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.ui.TranslationKeyField;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.ui.localize.LocalizationKeyWindow;
import org.teamapps.application.server.ui.localize.LocalizationUiUtils;
import org.teamapps.event.Event;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.linkbutton.LinkButton;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class LocalizationTranslationKeyField
implements TranslationKeyField {
    public final Event<String> onValueChanged = new Event();
    private final ComboBox<String> localizationKeyCombo;
    private final TextField keyTextField;
    private final LinkButton linkButton;

    public LocalizationTranslationKeyField(String linkButtonCaption, ApplicationInstanceData applicationInstanceData, SystemRegistry systemRegistry, Supplier<Application> applicationSupplier) {
        this(linkButtonCaption, applicationInstanceData, systemRegistry, applicationSupplier, false, false);
    }

    public LocalizationTranslationKeyField(String linkButtonCaption, ApplicationInstanceData applicationInstanceData, SystemRegistry systemRegistry, Supplier<Application> applicationSupplier, boolean allowMultiLine, boolean selectionFieldWithKey) {
        BaseTemplate template = selectionFieldWithKey ? BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES : BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE;
        this.localizationKeyCombo = LocalizationUiUtils.createLocalizationKeyCombo((Template)template, (ApplicationLocalizationProvider)applicationInstanceData, applicationSupplier);
        this.localizationKeyCombo.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        this.localizationKeyCombo.setShowClearButton(true);
        this.keyTextField = new TextField();
        this.keyTextField.setEditingMode(FieldEditingMode.READONLY);
        this.linkButton = new LinkButton(linkButtonCaption);
        this.localizationKeyCombo.onValueChanged.addListener(value -> {
            this.keyTextField.setValue(value);
            this.onValueChanged.fire(value);
        });
        LocalizationKeyWindow localizationKeyWindow = new LocalizationKeyWindow(applicationInstanceData, systemRegistry, applicationSupplier);
        localizationKeyWindow.onNewKey.addListener(value -> {
            this.localizationKeyCombo.setValue(value);
            this.keyTextField.setValue(value);
            this.localizationKeyCombo.onValueChanged.fire(value);
            this.onValueChanged.fire(value);
        });
        this.linkButton.onClicked.addListener(() -> {
            localizationKeyWindow.resetUi();
            localizationKeyWindow.show();
        });
    }

    public Event<String> getOnValueChanged() {
        return this.onValueChanged;
    }

    public AbstractField<String> getSelectionField() {
        return this.localizationKeyCombo;
    }

    public AbstractField<String> getKeyDisplayField() {
        return this.keyTextField;
    }

    public LinkButton getKeyLinkButton() {
        return this.linkButton;
    }

    public void setKey(String key) {
        this.localizationKeyCombo.setValue((Object)key);
        this.keyTextField.setValue((Object)key);
    }

    public String getKey() {
        return (String)this.localizationKeyCombo.getValue();
    }
}

